/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.associations.AbstractAssociator;
import weka.associations.tertius.AttributeValueLiteral;
import weka.associations.tertius.IndividualInstances;
import weka.associations.tertius.IndividualLiteral;
import weka.associations.tertius.Predicate;
import weka.associations.tertius.Rule;
import weka.associations.tertius.SimpleLinkedList;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Tertius
extends AbstractAssociator
implements OptionHandler,
Runnable,
TechnicalInformationHandler {
    static final long serialVersionUID = 5556726848380738179L;
    private SimpleLinkedList m_results;
    private int m_hypotheses;
    private int m_explored;
    private Date m_time;
    private TextField m_valuesText;
    private Instances m_instances;
    private ArrayList m_predicates;
    private int m_status;
    private static final int NORMAL = 0;
    private static final int MEMORY = 1;
    private static final int STOP = 2;
    private int m_best;
    private double m_frequencyThreshold;
    private double m_confirmationThreshold;
    private double m_noiseThreshold;
    private boolean m_repeat;
    private int m_numLiterals;
    private static final int NONE = 0;
    private static final int BODY = 1;
    private static final int HEAD = 2;
    private static final int ALL = 3;
    private static final Tag[] TAGS_NEGATION = new Tag[]{new Tag(0, "None"), new Tag(1, "Body"), new Tag(2, "Head"), new Tag(3, "Both")};
    private int m_negation;
    private boolean m_classification;
    private int m_classIndex;
    private boolean m_horn;
    private boolean m_equivalent;
    private boolean m_sameClause;
    private boolean m_subsumption;
    public static final int EXPLICIT = 0;
    public static final int IMPLICIT = 1;
    public static final int SIGNIFICANT = 2;
    private static final Tag[] TAGS_MISSING = new Tag[]{new Tag(0, "Matches all"), new Tag(1, "Matches none"), new Tag(2, "Significant")};
    private int m_missing;
    private boolean m_roc;
    private String m_partsString;
    private Instances m_parts;
    private static final int NO = 0;
    private static final int OUT = 1;
    private static final int WINDOW = 2;
    private static final Tag[] TAGS_VALUES = new Tag[]{new Tag(0, "No"), new Tag(1, "stdout"), new Tag(2, "Window")};
    private int m_printValues;

    public Tertius() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Finds rules according to confirmation measure (Tertius-type algorithm).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "P. A. Flach and N. Lachiche");
        result.setValue(TechnicalInformation.Field.YEAR, "1999");
        result.setValue(TechnicalInformation.Field.TITLE, "Confirmation-Guided Discovery of first-order rules with Tertius");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "42");
        result.setValue(TechnicalInformation.Field.PAGES, "61-95");
        return result;
    }

    public void resetOptions() {
        this.m_best = 10;
        this.m_frequencyThreshold = 0.0;
        this.m_confirmationThreshold = 0.0;
        this.m_noiseThreshold = 1.0;
        this.m_repeat = false;
        this.m_numLiterals = 4;
        this.m_negation = 0;
        this.m_classification = false;
        this.m_classIndex = 0;
        this.m_horn = false;
        this.m_equivalent = true;
        this.m_sameClause = true;
        this.m_subsumption = true;
        this.m_missing = 0;
        this.m_roc = false;
        this.m_partsString = "";
        this.m_parts = null;
        this.m_printValues = 0;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(17);
        newVector.addElement(new Option("\tSet maximum number of confirmation  values in the result. (default: 10)", "K", 1, "-K <number of values in result>"));
        newVector.addElement(new Option("\tSet frequency threshold for pruning. (default: 0)", "F", 1, "-F <frequency threshold>"));
        newVector.addElement(new Option("\tSet confirmation threshold. (default: 0)", "C", 1, "-C <confirmation threshold>"));
        newVector.addElement(new Option("\tSet noise threshold : maximum frequency of counter-examples.\n\t0 gives only satisfied rules. (default: 1)", "N", 1, "-N <noise threshold>"));
        newVector.addElement(new Option("\tAllow attributes to be repeated in a same rule.", "R", 0, "-R"));
        newVector.addElement(new Option("\tSet maximum number of literals in a rule. (default: 4)", "L", 1, "-L <number of literals>"));
        newVector.addElement(new Option("\tSet the negations in the rule. (default: 0)", "G", 1, "-G <0=no negation | 1=body | 2=head | 3=body and head>"));
        newVector.addElement(new Option("\tConsider only classification rules.", "S", 0, "-S"));
        newVector.addElement(new Option("\tSet index of class attribute. (default: last).", "c", 1, "-c <class index>"));
        newVector.addElement(new Option("\tConsider only horn clauses.", "H", 0, "-H"));
        newVector.addElement(new Option("\tKeep equivalent rules.", "E", 0, "-E"));
        newVector.addElement(new Option("\tKeep same clauses.", "M", 0, "-M"));
        newVector.addElement(new Option("\tKeep subsumed rules.", "T", 0, "-T"));
        newVector.addElement(new Option("\tSet the way to handle missing values. (default: 0)", "I", 1, "-I <0=always match | 1=never match | 2=significant>"));
        newVector.addElement(new Option("\tUse ROC analysis. ", "O", 0, "-O"));
        newVector.addElement(new Option("\tSet the file containing the parts of the individual for individual-based learning.", "p", 1, "-p <name of file>"));
        newVector.addElement(new Option("\tSet output of current values. (default: 0)", "P", 1, "-P <0=no output | 1=on stdout | 2=in separate window>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String printValuesString;
        String negationString;
        String noiseThresholdString;
        String confirmationThresholdString;
        String frequencyThresholdString;
        this.resetOptions();
        String bestString = Utils.getOption('K', options);
        if (bestString.length() != 0) {
            try {
                this.m_best = Integer.parseInt(bestString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -K option: " + e.getMessage() + ".");
            }
            if (this.m_best < 1) {
                throw new Exception("Number of confirmation values has to be greater than one!");
            }
        }
        if ((frequencyThresholdString = Utils.getOption('F', options)).length() != 0) {
            try {
                this.m_frequencyThreshold = new Double(frequencyThresholdString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -F option: " + e.getMessage() + ".");
            }
            if (this.m_frequencyThreshold < 0.0 || this.m_frequencyThreshold > 1.0) {
                throw new Exception("Frequency threshold has to be between zero and one!");
            }
        }
        if ((confirmationThresholdString = Utils.getOption('C', options)).length() != 0) {
            try {
                this.m_confirmationThreshold = new Double(confirmationThresholdString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -C option: " + e.getMessage() + ".");
            }
            if (this.m_confirmationThreshold < 0.0 || this.m_confirmationThreshold > 1.0) {
                throw new Exception("Confirmation threshold has to be between zero and one!");
            }
            if (bestString.length() != 0) {
                throw new Exception("Specifying both a number of confirmation values and a confirmation threshold doesn't make sense!");
            }
            if (this.m_confirmationThreshold != 0.0) {
                this.m_best = 0;
            }
        }
        if ((noiseThresholdString = Utils.getOption('N', options)).length() != 0) {
            try {
                this.m_noiseThreshold = new Double(noiseThresholdString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -N option: " + e.getMessage() + ".");
            }
            if (this.m_noiseThreshold < 0.0 || this.m_noiseThreshold > 1.0) {
                throw new Exception("Noise threshold has to be between zero and one!");
            }
        }
        this.m_repeat = Utils.getFlag('R', options);
        String numLiteralsString = Utils.getOption('L', options);
        if (numLiteralsString.length() != 0) {
            try {
                this.m_numLiterals = Integer.parseInt(numLiteralsString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -L option: " + e.getMessage() + ".");
            }
            if (this.m_numLiterals < 1) {
                throw new Exception("Number of literals has to be greater than one!");
            }
        }
        if ((negationString = Utils.getOption('G', options)).length() != 0) {
            SelectedTag selected;
            int tag;
            try {
                tag = Integer.parseInt(negationString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -G option: " + e.getMessage() + ".");
            }
            try {
                selected = new SelectedTag(tag, TAGS_NEGATION);
            }
            catch (Exception e) {
                throw new Exception("Value for -G option has to be between zero and three!");
            }
            this.setNegation(selected);
        }
        this.m_classification = Utils.getFlag('S', options);
        String classIndexString = Utils.getOption('c', options);
        if (classIndexString.length() != 0) {
            try {
                this.m_classIndex = Integer.parseInt(classIndexString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -c option: " + e.getMessage() + ".");
            }
        }
        this.m_horn = Utils.getFlag('H', options);
        if (this.m_horn && this.m_negation != 0) {
            throw new Exception("Considering horn clauses doesn't make sense if negation allowed!");
        }
        this.m_equivalent = !Utils.getFlag('E', options);
        this.m_sameClause = !Utils.getFlag('M', options);
        this.m_subsumption = !Utils.getFlag('T', options);
        String missingString = Utils.getOption('I', options);
        if (missingString.length() != 0) {
            SelectedTag selected;
            int tag;
            try {
                tag = Integer.parseInt(missingString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -I option: " + e.getMessage() + ".");
            }
            try {
                selected = new SelectedTag(tag, TAGS_MISSING);
            }
            catch (Exception e) {
                throw new Exception("Value for -I option has to be between zero and two!");
            }
            this.setMissingValues(selected);
        }
        this.m_roc = Utils.getFlag('O', options);
        this.m_partsString = Utils.getOption('p', options);
        if (this.m_partsString.length() != 0) {
            BufferedReader reader;
            try {
                reader = new BufferedReader(new FileReader(this.m_partsString));
            }
            catch (Exception e) {
                throw new Exception("Can't open file " + e.getMessage() + ".");
            }
            this.m_parts = new Instances(reader);
        }
        if ((printValuesString = Utils.getOption('P', options)).length() != 0) {
            SelectedTag selected;
            int tag;
            try {
                tag = Integer.parseInt(printValuesString);
            }
            catch (Exception e) {
                throw new Exception("Invalid value for -P option: " + e.getMessage() + ".");
            }
            try {
                selected = new SelectedTag(tag, TAGS_VALUES);
            }
            catch (Exception e) {
                throw new Exception("Value for -P option has to be between zero and two!");
            }
            this.setValuesOutput(selected);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.m_best > 0) {
            result.add("-K");
            result.add("" + this.m_best);
        }
        result.add("-F");
        result.add("" + this.m_frequencyThreshold);
        if (this.m_confirmationThreshold > 0.0) {
            result.add("-C");
            result.add("" + this.m_confirmationThreshold);
        }
        result.add("-N");
        result.add("" + this.m_noiseThreshold);
        if (this.m_repeat) {
            result.add("-R");
        }
        result.add("-L");
        result.add("" + this.m_numLiterals);
        result.add("-G");
        result.add("" + this.m_negation);
        if (this.m_classification) {
            result.add("-S");
        }
        result.add("-c");
        result.add("" + this.m_classIndex);
        if (this.m_horn) {
            result.add("-H");
        }
        if (!this.m_equivalent) {
            result.add("-E");
        }
        if (!this.m_sameClause) {
            result.add("-M");
        }
        if (!this.m_subsumption) {
            result.add("-T");
        }
        result.add("-I");
        result.add("" + this.m_missing);
        if (this.m_roc) {
            result.add("-O");
        }
        if (this.m_partsString.length() > 0) {
            result.add("-p");
            result.add("" + this.m_partsString);
        }
        result.add("-P");
        result.add("" + this.m_printValues);
        return result.toArray(new String[result.size()]);
    }

    public String confirmationValuesTipText() {
        return "Number of best confirmation values to find.";
    }

    public int getConfirmationValues() {
        return this.m_best;
    }

    public void setConfirmationValues(int v) {
        this.m_best = v;
    }

    public String frequencyThresholdTipText() {
        return "Minimum proportion of instances satisfying head and body of rules";
    }

    public double getFrequencyThreshold() {
        return this.m_frequencyThreshold;
    }

    public void setFrequencyThreshold(double v) {
        this.m_frequencyThreshold = v;
    }

    public String confirmationThresholdTipText() {
        return "Minimum confirmation of the rules.";
    }

    public double getConfirmationThreshold() {
        return this.m_confirmationThreshold;
    }

    public void setConfirmationThreshold(double v) {
        this.m_confirmationThreshold = v;
        if (v != 0.0) {
            this.m_best = 0;
        }
    }

    public String noiseThresholdTipText() {
        return "Maximum proportion of counter-instances of rules. If set to 0, only satisfied rules will be given.";
    }

    public double getNoiseThreshold() {
        return this.m_noiseThreshold;
    }

    public void setNoiseThreshold(double v) {
        this.m_noiseThreshold = v;
    }

    public String repeatLiteralsTipText() {
        return "Repeated attributes allowed.";
    }

    public boolean getRepeatLiterals() {
        return this.m_repeat;
    }

    public void setRepeatLiterals(boolean v) {
        this.m_repeat = v;
    }

    public String numberLiteralsTipText() {
        return "Maximum number of literals in a rule.";
    }

    public int getNumberLiterals() {
        return this.m_numLiterals;
    }

    public void setNumberLiterals(int v) {
        this.m_numLiterals = v;
    }

    public String negationTipText() {
        return "Set the type of negation allowed in the rule. Negation can be allowed in the body, in the head, in both or in none.";
    }

    public SelectedTag getNegation() {
        return new SelectedTag(this.m_negation, TAGS_NEGATION);
    }

    public void setNegation(SelectedTag v) {
        if (v.getTags() == TAGS_NEGATION) {
            this.m_negation = v.getSelectedTag().getID();
        }
    }

    public String classificationTipText() {
        return "Find only rules with the class in the head.";
    }

    public boolean getClassification() {
        return this.m_classification;
    }

    public void setClassification(boolean v) {
        this.m_classification = v;
    }

    public String classIndexTipText() {
        return "Index of the class attribute. If set to 0, the class will be the last attribute.";
    }

    public int getClassIndex() {
        return this.m_classIndex;
    }

    public void setClassIndex(int v) {
        this.m_classIndex = v;
    }

    public String hornClausesTipText() {
        return "Find rules with a single conclusion literal only.";
    }

    public boolean getHornClauses() {
        return this.m_horn;
    }

    public void setHornClauses(boolean v) {
        this.m_horn = v;
    }

    public String equivalentTipText() {
        return "Keep equivalent rules. A rule r2 is equivalent to a rule r1 if the body of r2 is the negation of the head of r1, and the head of r2 is the negation of the body of r1.";
    }

    public boolean disabled_getEquivalent() {
        return !this.m_equivalent;
    }

    public void disabled_setEquivalent(boolean v) {
        this.m_equivalent = !v;
    }

    public String sameClauseTipText() {
        return "Keep rules corresponding to the same clauses. If set to false, only the rule with the best confirmation value and rules with a lower number of counter-instances will be kept.";
    }

    public boolean disabled_getSameClause() {
        return !this.m_sameClause;
    }

    public void disabled_setSameClause(boolean v) {
        this.m_sameClause = !v;
    }

    public String subsumptionTipText() {
        return "Keep subsumed rules. If set to false, subsumed rules will only be kept if they have a better confirmation or a lower number of counter-instances.";
    }

    public boolean disabled_getSubsumption() {
        return !this.m_subsumption;
    }

    public void disabled_setSubsumption(boolean v) {
        this.m_subsumption = !v;
    }

    public String missingValuesTipText() {
        return "Set the way to handle missing values. Missing values can be set to match any value, or never match values or to be significant and possibly appear in rules.";
    }

    public SelectedTag getMissingValues() {
        return new SelectedTag(this.m_missing, TAGS_MISSING);
    }

    public void setMissingValues(SelectedTag v) {
        if (v.getTags() == TAGS_MISSING) {
            this.m_missing = v.getSelectedTag().getID();
        }
    }

    public String rocAnalysisTipText() {
        return "Return TP-rate and FP-rate for each rule found.";
    }

    public boolean getRocAnalysis() {
        return this.m_roc;
    }

    public void setRocAnalysis(boolean v) {
        this.m_roc = v;
    }

    public String partFileTipText() {
        return "Set file containing the parts of the individual for individual-based learning.";
    }

    public File disabled_getPartFile() {
        return new File(this.m_partsString);
    }

    public void disabled_setPartFile(File v) throws Exception {
        this.m_partsString = v.getAbsolutePath();
        if (this.m_partsString.length() != 0) {
            BufferedReader reader;
            try {
                reader = new BufferedReader(new FileReader(this.m_partsString));
            }
            catch (Exception e) {
                throw new Exception("Can't open file " + e.getMessage() + ".");
            }
            this.m_parts = new Instances(reader);
        }
    }

    public String valuesOutputTipText() {
        return "Give visual feedback during the search. The current best and worst values can be output either to stdout or to a separate window.";
    }

    public SelectedTag getValuesOutput() {
        return new SelectedTag(this.m_printValues, TAGS_VALUES);
    }

    public void setValuesOutput(SelectedTag v) {
        if (v.getTags() == TAGS_VALUES) {
            this.m_printValues = v.getSelectedTag().getID();
        }
    }

    private Predicate buildPredicate(Instances instances, Attribute attr, boolean isClass) throws Exception {
        int type;
        boolean individual = this.m_parts != null;
        int n = type = instances == this.m_parts ? IndividualLiteral.PART_PROPERTY : IndividualLiteral.INDIVIDUAL_PROPERTY;
        if (attr.isNumeric()) {
            throw new Exception("Can't handle numeric attributes!");
        }
        boolean missingValues = instances.attributeStats((int)attr.index()).missingCount > 0;
        Predicate predicate = individual ? new Predicate(instances.relationName() + "." + attr.name(), attr.index(), isClass) : new Predicate(attr.name(), attr.index(), isClass);
        if (!(attr.numValues() != 2 || missingValues && this.m_missing != 0)) {
            AttributeValueLiteral negation;
            AttributeValueLiteral lit;
            if (individual) {
                lit = new IndividualLiteral(predicate, attr.value(0), 0, 1, this.m_missing, type);
                negation = new IndividualLiteral(predicate, attr.value(1), 1, 1, this.m_missing, type);
            } else {
                lit = new AttributeValueLiteral(predicate, attr.value(0), 0, 1, this.m_missing);
                negation = new AttributeValueLiteral(predicate, attr.value(1), 1, 1, this.m_missing);
            }
            lit.setNegation(negation);
            negation.setNegation(lit);
            predicate.addLiteral(lit);
        } else {
            AttributeValueLiteral negation;
            AttributeValueLiteral lit;
            for (int i = 0; i < attr.numValues(); ++i) {
                lit = individual ? new IndividualLiteral(predicate, attr.value(i), i, 1, this.m_missing, type) : new AttributeValueLiteral(predicate, attr.value(i), i, 1, this.m_missing);
                if (this.m_negation != 0) {
                    negation = individual ? new IndividualLiteral(predicate, attr.value(i), i, 0, this.m_missing, type) : new AttributeValueLiteral(predicate, attr.value(i), i, 0, this.m_missing);
                    lit.setNegation(negation);
                    negation.setNegation(lit);
                }
                predicate.addLiteral(lit);
            }
            if (missingValues && this.m_missing == 2) {
                lit = individual ? new IndividualLiteral(predicate, "?", -1, 1, this.m_missing, type) : new AttributeValueLiteral(predicate, "?", -1, 1, this.m_missing);
                if (this.m_negation != 0) {
                    negation = individual ? new IndividualLiteral(predicate, "?", -1, 0, this.m_missing, type) : new AttributeValueLiteral(predicate, "?", -1, 0, this.m_missing);
                    lit.setNegation(negation);
                    negation.setNegation(lit);
                }
                predicate.addLiteral(lit);
            }
        }
        return predicate;
    }

    private ArrayList buildPredicates() throws Exception {
        Predicate predicate;
        Attribute attr;
        boolean individual;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Enumeration attributes = this.m_instances.enumerateAttributes();
        boolean bl = individual = this.m_parts != null;
        while (attributes.hasMoreElements()) {
            attr = (Attribute)attributes.nextElement();
            if (individual && attr.name().equals("id")) continue;
            predicate = this.buildPredicate(this.m_instances, attr, false);
            predicates.add(predicate);
        }
        attr = this.m_instances.classAttribute();
        if (!individual || !attr.name().equals("id")) {
            predicate = this.buildPredicate(this.m_instances, attr, true);
            predicates.add(predicate);
        }
        if (individual) {
            attributes = this.m_parts.enumerateAttributes();
            while (attributes.hasMoreElements()) {
                attr = (Attribute)attributes.nextElement();
                if (attr.name().equals("id")) continue;
                predicate = this.buildPredicate(this.m_parts, attr, false);
                predicates.add(predicate);
            }
        }
        return predicates;
    }

    private int numValuesInResult() {
        int result = 0;
        SimpleLinkedList.LinkedListIterator iter = this.m_results.iterator();
        if (!iter.hasNext()) {
            return result;
        }
        Rule current = (Rule)iter.next();
        while (iter.hasNext()) {
            Rule next = (Rule)iter.next();
            if (current.getConfirmation() > next.getConfirmation()) {
                ++result;
            }
            current = next;
        }
        return result + 1;
    }

    private boolean canRefine(Rule rule) {
        if (rule.isEmpty()) {
            return true;
        }
        if (this.m_best != 0) {
            if (this.numValuesInResult() < this.m_best) {
                return true;
            }
            Rule worstResult = (Rule)this.m_results.getLast();
            return rule.getOptimistic() >= worstResult.getConfirmation();
        }
        return true;
    }

    private boolean canCalculateOptimistic(Rule rule) {
        if (rule.hasTrueBody() || rule.hasFalseHead()) {
            return false;
        }
        return rule.overFrequencyThreshold(this.m_frequencyThreshold);
    }

    private boolean canExplore(Rule rule) {
        if (rule.getOptimistic() < this.m_confirmationThreshold) {
            return false;
        }
        if (this.m_best != 0) {
            if (this.numValuesInResult() < this.m_best) {
                return true;
            }
            Rule worstResult = (Rule)this.m_results.getLast();
            return rule.getOptimistic() >= worstResult.getConfirmation();
        }
        return true;
    }

    private boolean canStoreInNodes(Rule rule) {
        return rule.getObservedNumber() != 0;
    }

    private boolean canCalculateConfirmation(Rule rule) {
        return !(rule.getObservedFrequency() > this.m_noiseThreshold);
    }

    private boolean canStoreInResults(Rule rule) {
        if (rule.getConfirmation() < this.m_confirmationThreshold) {
            return false;
        }
        if (this.m_best != 0) {
            if (this.numValuesInResult() < this.m_best) {
                return true;
            }
            Rule worstResult = (Rule)this.m_results.getLast();
            return rule.getConfirmation() >= worstResult.getConfirmation();
        }
        return true;
    }

    private void addResult(Rule rule) {
        Rule current;
        boolean added = false;
        SimpleLinkedList.LinkedListIterator iter = this.m_results.iterator();
        while (iter.hasNext()) {
            current = (Rule)iter.next();
            if (Rule.confirmationThenObservedComparator.compare(current, rule) > 0) {
                iter.addBefore(rule);
                added = true;
                break;
            }
            if (!this.m_subsumption && !this.m_sameClause && !this.m_equivalent || !current.subsumes(rule) || !(current.numLiterals() == rule.numLiterals() ? (current.equivalentTo(rule) ? this.m_equivalent : this.m_sameClause && Rule.confirmationComparator.compare(current, rule) < 0) : this.m_subsumption && Rule.observedComparator.compare(current, rule) <= 0)) continue;
            return;
        }
        if (!added) {
            this.m_results.add(rule);
        }
        SimpleLinkedList.LinkedListInverseIterator inverse = this.m_results.inverseIterator();
        while (inverse.hasPrevious() && Rule.confirmationThenObservedComparator.compare(current = (Rule)inverse.previous(), rule) >= 0) {
            if (current == rule || !rule.subsumes(current)) continue;
            if (current.numLiterals() == rule.numLiterals()) {
                if (current.equivalentTo(rule) || !this.m_sameClause || Rule.confirmationComparator.compare(current, rule) <= 0) continue;
                inverse.remove();
                continue;
            }
            if (!this.m_subsumption || Rule.observedComparator.compare(rule, current) > 0) continue;
            inverse.remove();
        }
        if (this.m_best != 0 && this.numValuesInResult() > this.m_best) {
            Rule worstRule = (Rule)this.m_results.getLast();
            inverse = this.m_results.inverseIterator();
            while (inverse.hasPrevious() && Rule.confirmationComparator.compare(current = (Rule)inverse.previous(), worstRule) >= 0) {
                inverse.remove();
            }
        }
        this.printValues();
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildAssociations(Instances instances) throws Exception {
        Window valuesFrame = null;
        this.m_instances = this.m_parts == null ? new Instances(instances) : new IndividualInstances(new Instances(instances), this.m_parts);
        this.m_results = new SimpleLinkedList();
        this.m_hypotheses = 0;
        this.m_explored = 0;
        this.m_status = 0;
        if (this.m_classIndex == -1) {
            this.m_instances.setClassIndex(this.m_instances.numAttributes() - 1);
        } else if (this.m_classIndex < this.m_instances.numAttributes() && this.m_classIndex >= 0) {
            this.m_instances.setClassIndex(this.m_classIndex);
        } else {
            throw new Exception("Invalid class index.");
        }
        this.getCapabilities().testWithFail(this.m_instances);
        if (this.m_printValues == 2) {
            this.m_valuesText = new TextField(37);
            this.m_valuesText.setEditable(false);
            this.m_valuesText.setFont(new Font("Monospaced", 0, 12));
            Label valuesLabel = new Label("Best and worst current values:");
            Button stop = new Button("Stop search");
            stop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Tertius.this.m_status = 2;
                }
            });
            valuesFrame = new Frame("Tertius status");
            ((Frame)valuesFrame).setResizable(false);
            valuesFrame.add((Component)this.m_valuesText, "Center");
            valuesFrame.add((Component)stop, "South");
            valuesFrame.add((Component)valuesLabel, "North");
            valuesFrame.pack();
            valuesFrame.setVisible(true);
        } else if (this.m_printValues == 1) {
            System.out.println("Best and worst current values:");
        }
        Date start = new Date();
        this.m_predicates = this.buildPredicates();
        this.beginSearch();
        Date end = new Date();
        if (this.m_printValues == 2) {
            valuesFrame.dispose();
        }
        this.m_time = new Date(end.getTime() - start.getTime());
    }

    public void run() {
        try {
            this.search();
        }
        catch (OutOfMemoryError e) {
            System.gc();
            this.m_status = 1;
        }
        this.endSearch();
    }

    private synchronized void beginSearch() throws Exception {
        Thread search = new Thread(this);
        search.start();
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            this.m_status = 2;
        }
    }

    private synchronized void endSearch() {
        this.notify();
    }

    public void search() {
        Rule currentNode;
        SimpleLinkedList nodes = new SimpleLinkedList();
        boolean negBody = this.m_negation == 1 || this.m_negation == 3;
        boolean negHead = this.m_negation == 2 || this.m_negation == 3;
        nodes.add(new Rule(this.m_repeat, this.m_numLiterals, negBody, negHead, this.m_classification, this.m_horn));
        this.printValues();
        while (this.m_status != 2 && !nodes.isEmpty() && this.canRefine(currentNode = (Rule)nodes.removeFirst())) {
            SimpleLinkedList children = currentNode.refine(this.m_predicates);
            SimpleLinkedList.LinkedListIterator iter = children.iterator();
            while (iter.hasNext()) {
                ++this.m_hypotheses;
                Rule child = (Rule)iter.next();
                child.upDate(this.m_instances);
                if (this.canCalculateOptimistic(child)) {
                    child.calculateOptimistic();
                    if (this.canExplore(child)) {
                        ++this.m_explored;
                        if (!this.canStoreInNodes(child)) {
                            iter.remove();
                        }
                        if (!this.canCalculateConfirmation(child)) continue;
                        child.calculateConfirmation();
                        if (!this.canStoreInResults(child)) continue;
                        this.addResult(child);
                        continue;
                    }
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
            children.sort(Rule.optimisticThenObservedComparator);
            nodes.merge(children, Rule.optimisticThenObservedComparator);
        }
    }

    public SimpleLinkedList getResults() {
        return this.m_results;
    }

    private void printValues() {
        if (this.m_printValues == 0) {
            return;
        }
        if (this.m_results.isEmpty()) {
            if (this.m_printValues == 1) {
                System.out.print("0.000000 0.000000 - 0.000000 0.000000");
            } else {
                this.m_valuesText.setText("0.000000 0.000000 - 0.000000 0.000000");
            }
        } else {
            Rule best = (Rule)this.m_results.getFirst();
            Rule worst = (Rule)this.m_results.getLast();
            String values = best.valuesToString() + " - " + worst.valuesToString();
            if (this.m_printValues == 1) {
                System.out.print("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
                System.out.print(values);
            } else {
                this.m_valuesText.setText(values);
            }
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        SimpleLinkedList.LinkedListIterator iter = this.m_results.iterator();
        int size = this.m_results.size();
        int i = 0;
        text.append("\nTertius\n=======\n\n");
        while (iter.hasNext()) {
            Rule current = (Rule)iter.next();
            text.append(Utils.doubleToString((double)i + 1.0, (int)(Math.log(size) / Math.log(10.0) + 1.0), 0) + ". ");
            text.append("/* ");
            if (this.m_roc) {
                text.append(current.rocToString());
            } else {
                text.append(current.valuesToString());
            }
            text.append(" */ ");
            text.append(current.toString());
            text.append("\n");
            ++i;
        }
        text.append("\nNumber of hypotheses considered: " + this.m_hypotheses);
        text.append("\nNumber of hypotheses explored: " + this.m_explored);
        if (this.m_status == 1) {
            text.append("\n\nNot enough memory to continue the search");
        } else if (this.m_status == 2) {
            text.append("\n\nSearch interrupted");
        }
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5504 $");
    }

    public static void main(String[] args) {
        Tertius.runAssociator(new Tertius(), args);
    }
}

