/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import weka.core.ClassDiscovery;
import weka.core.Trie;
import weka.core.Utils;

public class SimpleCLIPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7377739469759943231L;
    protected static String FILENAME = "SimpleCLI.props";
    protected static String PROPERTY_FILE = "weka/gui/" + FILENAME;
    protected static Properties PROPERTIES;
    protected JTextArea m_OutputArea = new JTextArea();
    protected JTextField m_Input = new JTextField();
    protected Vector m_CommandHistory = new Vector();
    protected int m_HistoryPos = 0;
    protected PipedOutputStream m_POO = new PipedOutputStream();
    protected PipedOutputStream m_POE = new PipedOutputStream();
    protected Thread m_OutRedirector;
    protected Thread m_ErrRedirector;
    protected Thread m_RunThread;
    protected CommandlineCompletion m_Completion;

    public SimpleCLIPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_OutputArea), "Center");
        this.add((Component)this.m_Input, "South");
        this.m_Input.setFont(new Font("Monospaced", 0, 12));
        this.m_Input.addActionListener(this);
        this.m_Input.setFocusTraversalKeysEnabled(false);
        this.m_Input.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SimpleCLIPanel.this.doHistory(e);
                SimpleCLIPanel.this.doCommandlineCompletion(e);
            }
        });
        this.m_OutputArea.setEditable(false);
        this.m_OutputArea.setFont(new Font("Monospaced", 0, 12));
        PipedInputStream pio = new PipedInputStream(this.m_POO);
        System.setOut(new PrintStream(this.m_POO));
        InputStreamReader r = new InputStreamReader(pio);
        this.m_OutRedirector = new ReaderToTextArea(r, this.m_OutputArea);
        this.m_OutRedirector.start();
        PipedInputStream pie = new PipedInputStream(this.m_POE);
        System.setErr(new PrintStream(this.m_POE));
        r = new InputStreamReader(pie);
        this.m_ErrRedirector = new ReaderToTextArea(r, this.m_OutputArea);
        this.m_ErrRedirector.start();
        this.m_Completion = new CommandlineCompletion();
        System.out.println("\nWelcome to the WEKA SimpleCLI\n\nEnter commands in the textfield at the bottom of \nthe window. Use the up and down arrows to move \nthrough previous commands.\nCommand completion for classnames and files is \ninitiated with <Tab>. In order to distinguish \nbetween files and classnames, file names must \nbe either absolute or start with '." + File.separator + "' or '~/'\n" + "(the latter is a shortcut for the home directory).\n" + "<Alt+BackSpace> is used for deleting the text\n" + "in the commandline in chunks.\n");
        this.runCommand("help");
        this.loadHistory();
    }

    public void runCommand(String commands) throws Exception {
        System.out.println("> " + commands + '\n');
        System.out.flush();
        String[] commandArgs = Utils.splitOptions(commands);
        if (commandArgs.length == 0) {
            return;
        }
        if (commandArgs[0].equals("java")) {
            commandArgs[0] = "";
            try {
                if (commandArgs.length == 1) {
                    throw new Exception("No class name given");
                }
                String className = commandArgs[1];
                commandArgs[1] = "";
                if (this.m_RunThread != null) {
                    throw new Exception("An object is already running, use \"break\" to interrupt it.");
                }
                Class<?> theClass = Class.forName(className);
                Vector<String> argv = new Vector<String>();
                for (int i = 2; i < commandArgs.length; ++i) {
                    argv.add(commandArgs[i]);
                }
                this.m_RunThread = new ClassRunner(theClass, argv.toArray(new String[argv.size()]));
                this.m_RunThread.setPriority(1);
                this.m_RunThread.start();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else if (commandArgs[0].equals("cls")) {
            this.m_OutputArea.setText("");
        } else if (commandArgs[0].equals("history")) {
            System.out.println("Command history:");
            for (int i = 0; i < this.m_CommandHistory.size(); ++i) {
                System.out.println(this.m_CommandHistory.get(i));
            }
            System.out.println();
        } else if (commandArgs[0].equals("break")) {
            if (this.m_RunThread == null) {
                System.err.println("Nothing is currently running.");
            } else {
                System.out.println("[Interrupt...]");
                this.m_RunThread.interrupt();
            }
        } else if (commandArgs[0].equals("kill")) {
            if (this.m_RunThread == null) {
                System.err.println("Nothing is currently running.");
            } else {
                System.out.println("[Kill...]");
                this.m_RunThread.stop();
                this.m_RunThread = null;
            }
        } else if (commandArgs[0].equals("exit")) {
            Container parent = this.getParent();
            Container frame = null;
            boolean finished = false;
            while (!finished) {
                if (parent instanceof JFrame || parent instanceof Frame || parent instanceof JInternalFrame) {
                    frame = parent;
                    finished = true;
                }
                if (finished) continue;
                finished = (parent = parent.getParent()) == null;
            }
            if (frame != null) {
                if (frame instanceof JInternalFrame) {
                    ((JInternalFrame)frame).doDefaultCloseAction();
                } else {
                    ((Window)frame).dispatchEvent(new WindowEvent((Window)frame, 201));
                }
            }
        } else {
            boolean help;
            boolean bl = help = commandArgs.length > 1 && commandArgs[0].equals("help");
            if (help && commandArgs[1].equals("java")) {
                System.err.println("java <classname> <args>\n\nStarts the main method of <classname> with the supplied command line arguments (if any).\nThe command is started in a separate thread, and may be interrupted with the \"break\"\ncommand (friendly), or killed with the \"kill\" command (unfriendly).\nRedirecting can be done with '>' followed by the file to write to, e.g.:\n  java some.Class > ." + File.separator + "some.txt");
            } else if (help && commandArgs[1].equals("break")) {
                System.err.println("break\n\nAttempts to nicely interrupt the running job, if any. If this doesn't respond in an\nacceptable time, use \"kill\".\n");
            } else if (help && commandArgs[1].equals("kill")) {
                System.err.println("kill\n\nKills the running job, if any. You should only use this if the job doesn't respond to\n\"break\".\n");
            } else if (help && commandArgs[1].equals("cls")) {
                System.err.println("cls\n\nClears the output area.\n");
            } else if (help && commandArgs[1].equals("history")) {
                System.err.println("history\n\nPrints all issued commands.\n");
            } else if (help && commandArgs[1].equals("exit")) {
                System.err.println("exit\n\nExits the SimpleCLI program.\n");
            } else {
                System.err.println("Command must be one of:\n\tjava <classname> <args> [ > file]\n\tbreak\n\tkill\n\tcls\n\thistory\n\texit\n\thelp <command>\n");
            }
        }
    }

    public void doHistory(KeyEvent e) {
        if (e.getSource() == this.m_Input) {
            switch (e.getKeyCode()) {
                case 38: {
                    if (this.m_HistoryPos <= 0) break;
                    --this.m_HistoryPos;
                    String command = (String)this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    this.m_Input.setText(command);
                    break;
                }
                case 40: {
                    if (this.m_HistoryPos >= this.m_CommandHistory.size()) break;
                    ++this.m_HistoryPos;
                    String command = "";
                    if (this.m_HistoryPos < this.m_CommandHistory.size()) {
                        command = (String)this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    }
                    this.m_Input.setText(command);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommandlineCompletion(KeyEvent e) {
        if (e.getSource() == this.m_Input) {
            switch (e.getKeyCode()) {
                case 9: {
                    if (e.getModifiers() != 0) break;
                    this.m_Input.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_OutputArea.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        String txt = this.m_Input.getText();
                        if (txt.trim().startsWith("java ")) {
                            int pos = this.m_Input.getCaretPosition();
                            int nonNameCharPos = -1;
                            for (int i = pos - 1; i >= 0; --i) {
                                if (txt.charAt(i) != '\"' && txt.charAt(i) != ' ') continue;
                                nonNameCharPos = i;
                                break;
                            }
                            if (nonNameCharPos > -1) {
                                String search = txt.substring(nonNameCharPos + 1, pos);
                                Vector<String> list = this.m_Completion.getMatches(search);
                                String common = this.m_Completion.getCommonPrefix(list);
                                if ((search.toLowerCase() + File.separator).equals(common.toLowerCase())) {
                                    common = search;
                                }
                                if (common.length() > search.length()) {
                                    try {
                                        this.m_Input.getDocument().remove(nonNameCharPos + 1, search.length());
                                        this.m_Input.getDocument().insertString(nonNameCharPos + 1, common, null);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                } else if (list.size() > 1) {
                                    System.out.println("\nPossible matches:");
                                    for (int i = 0; i < list.size(); ++i) {
                                        System.out.println("  " + list.get(i));
                                    }
                                }
                            }
                        }
                        Object var10_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        this.m_Input.setCursor(null);
                        this.m_OutputArea.setCursor(null);
                        throw throwable;
                    }
                    this.m_Input.setCursor(null);
                    this.m_OutputArea.setCursor(null);
                    break;
                }
                case 8: {
                    int pos;
                    if (e.getModifiers() != 8) break;
                    String txt = this.m_Input.getText();
                    int start = pos = this.m_Input.getCaretPosition();
                    --start;
                    while (start >= 0 && (txt.charAt(start) == '.' || txt.charAt(start) == ' ' || txt.charAt(start) == '\\' || txt.charAt(start) == '/')) {
                        --start;
                    }
                    int newPos = -1;
                    for (int i = start; i >= 0; --i) {
                        if (txt.charAt(i) != '.' && txt.charAt(i) != ' ' && txt.charAt(i) != '\\' && txt.charAt(i) != '/') continue;
                        newPos = i;
                        break;
                    }
                    try {
                        this.m_Input.getDocument().remove(newPos + 1, pos - newPos - 1);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_Input) {
                String command = this.m_Input.getText();
                int last = this.m_CommandHistory.size() - 1;
                if (last < 0 || !command.equals((String)this.m_CommandHistory.elementAt(last))) {
                    this.m_CommandHistory.addElement(command);
                    this.saveHistory();
                }
                this.m_HistoryPos = this.m_CommandHistory.size();
                this.runCommand(command);
                this.m_Input.setText("");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    protected void loadHistory() {
        String cmd;
        int size = Integer.parseInt(PROPERTIES.getProperty("HistorySize", "50"));
        this.m_CommandHistory.clear();
        for (int i = 0; i < size && (cmd = PROPERTIES.getProperty("Command" + i, "")).length() != 0; ++i) {
            this.m_CommandHistory.add(cmd);
        }
        this.m_HistoryPos = this.m_CommandHistory.size();
    }

    protected void saveHistory() {
        int size = Integer.parseInt(PROPERTIES.getProperty("HistorySize", "50"));
        int from = this.m_CommandHistory.size() - size;
        if (from < 0) {
            from = 0;
        }
        PROPERTIES.setProperty("HistorySize", "" + size);
        for (int i = from; i < this.m_CommandHistory.size(); ++i) {
            PROPERTIES.setProperty("Command" + (i - from), (String)this.m_CommandHistory.get(i));
        }
        try {
            String filename = System.getProperties().getProperty("user.home") + File.separatorChar + FILENAME;
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filename));
            PROPERTIES.store(stream, "SimpleCLI");
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleCLIPanel panel = new SimpleCLIPanel();
        JFrame f = new JFrame();
        f.setTitle("SimpleCLI");
        f.getContentPane().add(panel);
        f.setDefaultCloseOperation(2);
        f.pack();
        f.setSize(600, 500);
        f.setVisible(true);
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            Enumeration<?> keys = PROPERTIES.propertyNames();
            if (!keys.hasMoreElements()) {
                throw new Exception("Failed to read a property file for the SimpleCLI");
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the SimpleCLI.\nAn example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "SimpleCLI", 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommandlineCompletion {
        protected static Vector<String> m_Packages;
        protected static Trie m_Trie;
        protected boolean m_Debug = false;

        public CommandlineCompletion() {
            if (m_Packages == null) {
                Vector list = ClassDiscovery.findPackages();
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    String[] parts = ((String)list.get(i)).split("\\.");
                    for (int n = 1; n < parts.length; ++n) {
                        String pkg = "";
                        for (int m = 0; m <= n; ++m) {
                            if (m > 0) {
                                pkg = pkg + ".";
                            }
                            pkg = pkg + parts[m];
                        }
                        set.add(pkg);
                    }
                }
                m_Packages = new Vector();
                m_Packages.addAll(set);
                Collections.sort(m_Packages);
                m_Trie = new Trie();
                m_Trie.addAll((Collection<? extends String>)m_Packages);
            }
        }

        public boolean getDebug() {
            return this.m_Debug;
        }

        public void setDebug(boolean value) {
            this.m_Debug = value;
        }

        public boolean isClassname(String partial) {
            return partial.replaceAll("[a-zA-Z0-9\\-\\.]*", "").length() == 0;
        }

        public String getPackage(String partial) {
            String result = "";
            boolean wasDot = false;
            for (int i = 0; i < partial.length(); ++i) {
                char c = partial.charAt(i);
                if (wasDot && c >= 'A' && c <= 'Z') break;
                if (c == '.') {
                    wasDot = true;
                    result = result + "" + c;
                    continue;
                }
                wasDot = false;
                result = result + "" + c;
            }
            if (result.endsWith(".")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }

        public String getClassname(String partial) {
            String pkg = this.getPackage(partial);
            String result = pkg.length() + 1 < partial.length() ? partial.substring(pkg.length() + 1) : "";
            return result;
        }

        public Vector<String> getFileMatches(String partial) {
            int i;
            boolean caseSensitive;
            Vector<String> result = new Vector<String>();
            boolean bl = caseSensitive = File.separatorChar != '\\';
            if (this.m_Debug) {
                System.out.println("case-sensitive=" + caseSensitive);
            }
            if (partial.startsWith("~")) {
                partial = System.getProperty("user.home") + partial.substring(1);
            }
            File file = new File(partial);
            File dir = null;
            String prefix = null;
            if (file.exists()) {
                if (file.isDirectory()) {
                    dir = file;
                    prefix = null;
                } else {
                    dir = file.getParentFile();
                    prefix = file.getName();
                }
            } else {
                dir = file.getParentFile();
                prefix = file.getName();
            }
            if (this.m_Debug) {
                System.out.println("search in dir=" + dir + ", prefix=" + prefix);
            }
            if (dir != null) {
                File[] files = dir.listFiles();
                if (files != null) {
                    for (i = 0; i < files.length; ++i) {
                        String name = files[i].getName();
                        boolean match = prefix != null && caseSensitive ? name.startsWith(prefix) : (prefix != null && !caseSensitive ? name.toLowerCase().startsWith(prefix.toLowerCase()) : true);
                        if (!match) continue;
                        if (prefix != null) {
                            result.add(partial.substring(0, partial.length() - prefix.length()) + name);
                            continue;
                        }
                        if (partial.endsWith("\\") || partial.endsWith("/")) {
                            result.add(partial + name);
                            continue;
                        }
                        result.add(partial + File.separator + name);
                    }
                } else {
                    System.err.println("Invalid path: " + partial);
                }
            }
            if (result.size() > 1) {
                Collections.sort(result);
            }
            if (this.m_Debug) {
                System.out.println("file matches:");
                for (i = 0; i < result.size(); ++i) {
                    System.out.println(result.get(i));
                }
            }
            return result;
        }

        public Vector<String> getClassMatches(String partial) {
            int i;
            Vector<String> list;
            String pkg = this.getPackage(partial);
            String cls = this.getClassname(partial);
            if (this.getDebug()) {
                System.out.println("\nsearch for: '" + partial + "' => package=" + pkg + ", class=" + cls);
            }
            Vector<String> result = new Vector<String>();
            if (cls.length() == 0) {
                list = m_Trie.getWithPrefix(pkg);
                HashSet<String> set = new HashSet<String>();
                for (i = 0; i < list.size(); ++i) {
                    String tmpStr = list.get(i);
                    if (tmpStr.length() < partial.length() || tmpStr.equals(partial)) continue;
                    int index = tmpStr.indexOf(46, partial.length() + 1);
                    if (index > -1) {
                        set.add(tmpStr.substring(0, index));
                        continue;
                    }
                    set.add(tmpStr);
                }
                result.addAll(set);
                if (result.size() > 1) {
                    Collections.sort(result);
                }
            }
            list = ClassDiscovery.find(Object.class, pkg);
            Trie tmpTrie = new Trie();
            tmpTrie.addAll((Collection<? extends String>)list);
            list = tmpTrie.getWithPrefix(partial);
            result.addAll(list);
            if (result.size() > 1) {
                Collections.sort(result);
            }
            if (this.m_Debug) {
                System.out.println("class/package matches:");
                for (i = 0; i < result.size(); ++i) {
                    System.out.println(result.get(i));
                }
            }
            return result;
        }

        public Vector<String> getMatches(String partial) {
            if (this.isClassname(partial)) {
                return this.getClassMatches(partial);
            }
            return this.getFileMatches(partial);
        }

        public String getCommonPrefix(Vector<String> list) {
            Trie trie = new Trie();
            trie.addAll((Collection<? extends String>)list);
            String result = trie.getCommonPrefix();
            if (this.m_Debug) {
                System.out.println(list + "\n  --> common prefix: '" + result + "'");
            }
            return result;
        }
    }

    class ClassRunner
    extends Thread {
        protected Method m_MainMethod;
        String[] m_CommandArgs;

        public ClassRunner(Class theClass, String[] commandArgs) throws Exception {
            this.setDaemon(true);
            Class[] argTemplate = new Class[]{String[].class};
            this.m_CommandArgs = commandArgs;
            this.m_MainMethod = theClass.getMethod("main", argTemplate);
            if ((this.m_MainMethod.getModifiers() & 8) == 0 || (this.m_MainMethod.getModifiers() & 1) == 0) {
                throw new NoSuchMethodException("main(String[]) method of " + theClass.getName() + " is not public and static.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String action;
            PrintStream outOld = null;
            PrintStream outNew = null;
            String outFilename = null;
            if (this.m_CommandArgs.length > 2 && (action = this.m_CommandArgs[this.m_CommandArgs.length - 2]).equals(">")) {
                outOld = System.out;
                try {
                    outFilename = this.m_CommandArgs[this.m_CommandArgs.length - 1];
                    if (outFilename.startsWith("~")) {
                        outFilename = outFilename.replaceFirst("~", System.getProperty("user.home"));
                    }
                    outNew = new PrintStream(new File(outFilename));
                    System.setOut(outNew);
                    this.m_CommandArgs[this.m_CommandArgs.length - 2] = "";
                    this.m_CommandArgs[this.m_CommandArgs.length - 1] = "";
                    String[] newArgs = new String[this.m_CommandArgs.length - 2];
                    System.arraycopy(this.m_CommandArgs, 0, newArgs, 0, this.m_CommandArgs.length - 2);
                    this.m_CommandArgs = newArgs;
                }
                catch (Exception e) {
                    System.setOut(outOld);
                    outOld = null;
                }
            }
            try {
                block11: {
                    try {
                        Object[] args = new Object[]{this.m_CommandArgs};
                        this.m_MainMethod.invoke(null, args);
                        if (!this.isInterrupted()) break block11;
                        System.err.println("[...Interrupted]");
                    }
                    catch (Exception ex) {
                        if (ex.getMessage() == null) {
                            System.err.println("[...Killed]");
                        } else {
                            System.err.println("[Run exception] " + ex.getMessage());
                        }
                        Object var7_9 = null;
                        SimpleCLIPanel.this.m_RunThread = null;
                    }
                }
                Object var7_8 = null;
                SimpleCLIPanel.this.m_RunThread = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                SimpleCLIPanel.this.m_RunThread = null;
                throw throwable;
            }
            if (outOld != null) {
                outNew.flush();
                outNew.close();
                System.setOut(outOld);
                System.out.println("Finished redirecting output to '" + outFilename + "'.");
            }
        }
    }

    class ReaderToTextArea
    extends Thread {
        protected LineNumberReader m_Input;
        protected JTextArea m_Output;

        public ReaderToTextArea(Reader input, JTextArea output) {
            this.setDaemon(true);
            this.m_Input = new LineNumberReader(input);
            this.m_Output = output;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.m_Output.append(this.m_Input.readLine() + '\n');
                        this.m_Output.setCaretPosition(this.m_Output.getDocument().getLength());
                    }
                }
                catch (Exception ex) {
                    try {
                        ReaderToTextArea.sleep(100L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

