/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class AddID
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 4734383199819293390L;
    protected SingleIndex m_Index = new SingleIndex("first");
    protected String m_Name = "ID";
    protected int m_Counter = -1;

    public String globalInfo() {
        return "An instance filter that adds an ID attribute to the dataset. The new attribute contains a unique ID for each instance.\nNote: The ID is not reset for the second batch of files (using -b and -r and -s).";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecify where to insert the ID. First and last\n\tare valid indexes.(default first)", "C", 1, "-C <index>"));
        vector.addElement(new Option("\tName of the new attribute.\n\t(default = 'ID')", "N", 1, "-N <name>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.m_Index.setSingleIndex(string);
        } else {
            this.m_Index.setSingleIndex("first");
        }
        string = Utils.getOption('N', stringArray);
        this.m_Name = string.length() != 0 ? string : "ID";
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-C");
        vector.add(this.getIDIndex());
        vector.add("-N");
        vector.add(this.getAttributeName());
        return vector.toArray(new String[vector.size()]);
    }

    public String attributeNameTipText() {
        return "Set the new attribute's name.";
    }

    public String getAttributeName() {
        return this.m_Name;
    }

    public void setAttributeName(String string) {
        this.m_Name = string;
    }

    public String IDIndexTipText() {
        return "The position (starting from 1) where the attribute will be inserted (first and last are valid indices).";
    }

    public String getIDIndex() {
        return this.m_Index.getSingleIndex();
    }

    public void setIDIndex(String string) {
        this.m_Index.setSingleIndex(string);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_Counter = -1;
        this.m_Index.setUpper(instances.numAttributes());
        Instances instances2 = new Instances(instances, 0);
        Attribute attribute = new Attribute(this.m_Name);
        if (this.m_Index.getIndex() < 0 || this.m_Index.getIndex() > this.getInputFormat().numAttributes()) {
            throw new IllegalArgumentException("Index out of range");
        }
        instances2.insertAttributeAt(attribute, this.m_Index.getIndex());
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!this.isFirstBatchDone()) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.m_Counter = 0;
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    protected void convertInstance(Instance instance) {
        ++this.m_Counter;
        try {
            Instance instance2 = (Instance)instance.copy();
            this.copyValues(instance2, true, instance2.dataset(), this.getOutputFormat());
            instance2.setDataset(null);
            instance2.insertAttributeAt(this.m_Index.getIndex());
            instance2.setValue(this.m_Index.getIndex(), (double)this.m_Counter);
            instance2.setDataset(this.getOutputFormat());
            this.push(instance2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        AddID.runFilter(new AddID(), stringArray);
    }
}

