/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.StreamableFilter;
import weka.filters.SupervisedFilter;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ConnectionNotificationConsumer;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.LogWriter;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Filter
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
Serializable,
UserRequestAcceptor,
TrainingSetListener,
TestSetListener,
TrainingSetProducer,
TestSetProducer,
DataSource,
DataSourceListener,
InstanceListener,
EventConstraints {
    private static final long serialVersionUID = 8249759470189439321L;
    protected BeanVisual m_visual = new BeanVisual("Filter", "weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
    private static int IDLE = 0;
    private static int FILTERING_TRAINING = 1;
    private static int FILTERING_TEST = 2;
    private int m_state = IDLE;
    protected Thread m_filterThread = null;
    private transient Instances m_trainingSet;
    private transient Instances m_testingSet;
    protected String m_globalInfo;
    private Hashtable m_listenees = new Hashtable();
    private Vector m_trainingListeners = new Vector();
    private Vector m_testListeners = new Vector();
    private Vector m_instanceListeners = new Vector();
    private Vector m_dataListeners = new Vector();
    private weka.filters.Filter m_Filter = new AllFilter();
    private InstanceEvent m_ie = new InstanceEvent(this);
    private transient Logger m_log = null;
    private boolean m_structurePassedOn = false;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Filter() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setFilter(this.m_Filter);
    }

    public void setFilter(weka.filters.Filter filter) {
        boolean bl = true;
        if (filter.getClass().getName().compareTo(this.m_Filter.getClass().getName()) == 0) {
            bl = false;
        }
        this.m_Filter = filter;
        String string = filter.getClass().toString();
        string = string.substring(string.indexOf(46) + 1, string.length());
        if (bl) {
            if (this.m_Filter instanceof Visible) {
                this.m_visual = ((Visible)((Object)this.m_Filter)).getVisual();
            } else if (!this.m_visual.loadIcons("weka/gui/beans/icons/" + string + ".gif", "weka/gui/beans/icons/" + string + "_animated.gif")) {
                this.useDefaultVisual();
            }
        }
        this.m_visual.setText(string.substring(string.lastIndexOf(46) + 1, string.length()));
        if (this.m_Filter instanceof LogWriter && this.m_log != null) {
            ((LogWriter)((Object)this.m_Filter)).setLog(this.m_log);
        }
        if (!(this.m_Filter instanceof StreamableFilter) && this.m_listenees.containsKey("instance") && this.m_log != null) {
            this.m_log.logMessage("WARNING : " + this.m_Filter.getClass().getName() + " is not an incremental filter");
        }
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Filter);
    }

    public weka.filters.Filter getFilter() {
        return this.m_Filter;
    }

    public void setWrappedAlgorithm(Object object) {
        if (!(object instanceof weka.filters.Filter)) {
            throw new IllegalArgumentException(object.getClass() + " : incorrect " + "type of algorithm (Filter)");
        }
        this.setFilter((weka.filters.Filter)object);
    }

    public Object getWrappedAlgorithm() {
        return this.getFilter();
    }

    public void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        this.processTrainingOrDataSourceEvents(trainingSetEvent);
    }

    public void acceptInstance(InstanceEvent instanceEvent) {
        if (this.m_filterThread != null) {
            String string = "Filter is currently batch processing!";
            if (this.m_log != null) {
                this.m_log.logMessage(string);
            } else {
                System.err.println(string);
            }
            return;
        }
        if (!(this.m_Filter instanceof StreamableFilter)) {
            if (this.m_log != null) {
                this.m_log.logMessage("ERROR : " + this.m_Filter.getClass().getName() + "can't process streamed instances; can't continue");
            }
            return;
        }
        if (instanceEvent.getStatus() == 0) {
            try {
                Instances instances = instanceEvent.getStructure();
                if (this.m_Filter instanceof SupervisedFilter && instances.classIndex() < 0) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                }
                this.m_Filter.setInputFormat(instances);
                this.m_structurePassedOn = false;
                try {
                    if (this.m_Filter.isOutputFormatDefined()) {
                        this.m_ie.setStructure(this.m_Filter.getOutputFormat());
                        this.notifyInstanceListeners(this.m_ie);
                        this.m_structurePassedOn = true;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error in obtaining post-filter structure: Filter.java");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        try {
            if (!this.m_Filter.input(instanceEvent.getInstance())) {
                if (this.m_log != null) {
                    this.m_log.logMessage("ERROR : filter not ready to output instance");
                }
                return;
            }
            Instance instance = this.m_Filter.output();
            if (instance == null) {
                return;
            }
            if (!this.m_structurePassedOn) {
                this.m_ie.setStructure(new Instances(instance.dataset(), 0));
                this.notifyInstanceListeners(this.m_ie);
                this.m_structurePassedOn = true;
            }
            this.m_ie.setInstance(instance);
            this.m_ie.setStatus(instanceEvent.getStatus());
            this.notifyInstanceListeners(this.m_ie);
        }
        catch (Exception exception) {
            if (this.m_log != null) {
                this.m_log.logMessage(exception.toString());
            }
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTrainingOrDataSourceEvents(EventObject eventObject) {
        block9: {
            boolean bl = false;
            if (eventObject instanceof DataSetEvent && (bl = ((DataSetEvent)eventObject).isStructureOnly())) {
                this.notifyDataOrTrainingListeners(eventObject);
            }
            if (eventObject instanceof TrainingSetEvent && (bl = ((TrainingSetEvent)eventObject).isStructureOnly())) {
                this.notifyDataOrTrainingListeners(eventObject);
            }
            if (bl && !(this.m_Filter instanceof StreamableFilter)) {
                return;
            }
            if (this.m_filterThread == null) {
                try {
                    if (this.m_state != IDLE) break block9;
                    Object object = this;
                    synchronized (object) {
                        this.m_state = FILTERING_TRAINING;
                    }
                    this.m_trainingSet = eventObject instanceof TrainingSetEvent ? ((TrainingSetEvent)eventObject).getTrainingSet() : ((DataSetEvent)eventObject).getDataSet();
                    object = this.m_visual.getText();
                    this.m_filterThread = new Thread((String)object, eventObject){
                        final /* synthetic */ String val$oldText;
                        final /* synthetic */ EventObject val$e;
                        {
                            this.val$oldText = string;
                            this.val$e = eventObject;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                block13: {
                                    try {
                                        EventObject eventObject;
                                        if (Filter.this.m_trainingSet == null) break block13;
                                        Filter.this.m_visual.setAnimated();
                                        Filter.this.m_visual.setText("Filtering training data...");
                                        if (Filter.this.m_log != null) {
                                            Filter.this.m_log.statusMessage("Filter : filtering training data (" + Filter.this.m_trainingSet.relationName());
                                        }
                                        Filter.this.m_Filter.setInputFormat(Filter.this.m_trainingSet);
                                        Instances instances = weka.filters.Filter.useFilter(Filter.this.m_trainingSet, Filter.this.m_Filter);
                                        Filter.this.m_visual.setText(this.val$oldText);
                                        Filter.this.m_visual.setStatic();
                                        if (this.val$e instanceof TrainingSetEvent) {
                                            eventObject = new TrainingSetEvent(Filter.this, instances);
                                            eventObject.m_setNumber = ((TrainingSetEvent)this.val$e).m_setNumber;
                                            eventObject.m_maxSetNumber = ((TrainingSetEvent)this.val$e).m_maxSetNumber;
                                        } else {
                                            eventObject = new DataSetEvent(Filter.this, instances);
                                        }
                                        Filter.this.notifyDataOrTrainingListeners(eventObject);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        Object var4_5 = null;
                                        Filter.this.m_visual.setText(this.val$oldText);
                                        Filter.this.m_visual.setStatic();
                                        Filter.this.m_state = IDLE;
                                        if (this.isInterrupted()) {
                                            Filter.this.m_trainingSet = null;
                                            if (Filter.this.m_log != null) {
                                                Filter.this.m_log.logMessage("Filter training set interrupted!");
                                                Filter.this.m_log.statusMessage("OK");
                                            }
                                        }
                                        Filter.this.block(false);
                                        return;
                                    }
                                }
                                Object var4_4 = null;
                                Filter.this.m_visual.setText(this.val$oldText);
                                Filter.this.m_visual.setStatic();
                                Filter.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Filter.this.m_trainingSet = null;
                                    if (Filter.this.m_log != null) {
                                        Filter.this.m_log.logMessage("Filter training set interrupted!");
                                        Filter.this.m_log.statusMessage("OK");
                                    }
                                }
                                Filter.this.block(false);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                Filter.this.m_visual.setText(this.val$oldText);
                                Filter.this.m_visual.setStatic();
                                Filter.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Filter.this.m_trainingSet = null;
                                    if (Filter.this.m_log != null) {
                                        Filter.this.m_log.logMessage("Filter training set interrupted!");
                                        Filter.this.m_log.statusMessage("OK");
                                    }
                                }
                                Filter.this.block(false);
                                throw throwable;
                            }
                        }
                    };
                    this.m_filterThread.setPriority(1);
                    this.m_filterThread.start();
                    this.block(true);
                    this.m_filterThread = null;
                    this.m_state = IDLE;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void acceptTestSet(final TestSetEvent testSetEvent) {
        if (testSetEvent.isStructureOnly()) {
            this.notifyTestListeners(testSetEvent);
        }
        if (this.m_trainingSet != null && this.m_trainingSet.equalHeaders(testSetEvent.getTestSet()) && this.m_filterThread == null) {
            try {
                if (this.m_state == IDLE) {
                    this.m_state = FILTERING_TEST;
                }
                this.m_testingSet = testSetEvent.getTestSet();
                final String string = this.m_visual.getText();
                this.m_filterThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            block11: {
                                try {
                                    if (Filter.this.m_testingSet == null) break block11;
                                    Filter.this.m_visual.setAnimated();
                                    Filter.this.m_visual.setText("Filtering test data...");
                                    if (Filter.this.m_log != null) {
                                        Filter.this.m_log.statusMessage("Filter : filtering test data (" + Filter.this.m_testingSet.relationName());
                                    }
                                    Instances instances = weka.filters.Filter.useFilter(Filter.this.m_testingSet, Filter.this.m_Filter);
                                    Filter.this.m_visual.setText(string);
                                    Filter.this.m_visual.setStatic();
                                    TestSetEvent testSetEvent2 = new TestSetEvent(Filter.this, instances);
                                    testSetEvent2.m_setNumber = testSetEvent.m_setNumber;
                                    testSetEvent2.m_maxSetNumber = testSetEvent.m_maxSetNumber;
                                    Filter.this.notifyTestListeners(testSetEvent2);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Object var4_5 = null;
                                    Filter.this.m_visual.setText(string);
                                    Filter.this.m_visual.setStatic();
                                    Filter.this.m_state = IDLE;
                                    if (this.isInterrupted()) {
                                        Filter.this.m_trainingSet = null;
                                        if (Filter.this.m_log != null) {
                                            Filter.this.m_log.logMessage("Filter test set interrupted!");
                                            Filter.this.m_log.statusMessage("OK");
                                        }
                                    }
                                    Filter.this.block(false);
                                    return;
                                }
                            }
                            Object var4_4 = null;
                            Filter.this.m_visual.setText(string);
                            Filter.this.m_visual.setStatic();
                            Filter.this.m_state = IDLE;
                            if (this.isInterrupted()) {
                                Filter.this.m_trainingSet = null;
                                if (Filter.this.m_log != null) {
                                    Filter.this.m_log.logMessage("Filter test set interrupted!");
                                    Filter.this.m_log.statusMessage("OK");
                                }
                            }
                            Filter.this.block(false);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            Filter.this.m_visual.setText(string);
                            Filter.this.m_visual.setStatic();
                            Filter.this.m_state = IDLE;
                            if (this.isInterrupted()) {
                                Filter.this.m_trainingSet = null;
                                if (Filter.this.m_log != null) {
                                    Filter.this.m_log.logMessage("Filter test set interrupted!");
                                    Filter.this.m_log.statusMessage("OK");
                                }
                            }
                            Filter.this.block(false);
                            throw throwable;
                        }
                    }
                };
                this.m_filterThread.setPriority(1);
                this.m_filterThread.start();
                this.block(true);
                this.m_filterThread = null;
                this.m_state = IDLE;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void acceptDataSet(DataSetEvent dataSetEvent) {
        this.processTrainingOrDataSourceEvents(dataSetEvent);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
    }

    public synchronized void addTrainingSetListener(TrainingSetListener trainingSetListener) {
        this.m_trainingListeners.addElement(trainingSetListener);
    }

    public synchronized void removeTrainingSetListener(TrainingSetListener trainingSetListener) {
        this.m_trainingListeners.removeElement(trainingSetListener);
    }

    public synchronized void addTestSetListener(TestSetListener testSetListener) {
        this.m_testListeners.addElement(testSetListener);
    }

    public synchronized void removeTestSetListener(TestSetListener testSetListener) {
        this.m_testListeners.removeElement(testSetListener);
    }

    public synchronized void addDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataListeners.addElement(dataSourceListener);
    }

    public synchronized void removeDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataListeners.remove(dataSourceListener);
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        this.m_instanceListeners.addElement(instanceListener);
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        this.m_instanceListeners.removeElement(instanceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataOrTrainingListeners(EventObject eventObject) {
        Vector vector;
        Filter filter = this;
        synchronized (filter) {
            vector = eventObject instanceof TrainingSetEvent ? (Vector)this.m_trainingListeners.clone() : (Vector)this.m_dataListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                if (eventObject instanceof TrainingSetEvent) {
                    ((TrainingSetListener)vector.elementAt(i)).acceptTrainingSet((TrainingSetEvent)eventObject);
                    continue;
                }
                ((DataSourceListener)vector.elementAt(i)).acceptDataSet((DataSetEvent)eventObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTestListeners(TestSetEvent testSetEvent) {
        Vector vector;
        Filter filter = this;
        synchronized (filter) {
            vector = (Vector)this.m_testListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TestSetListener)vector.elementAt(i)).acceptTestSet(testSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceListeners(InstanceEvent instanceEvent) {
        Vector vector;
        Filter filter = this;
        synchronized (filter) {
            vector = (Vector)this.m_instanceListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((InstanceListener)vector.elementAt(i)).acceptInstance(instanceEvent);
            }
        }
    }

    public boolean connectionAllowed(String string) {
        if (this.m_listenees.containsKey(string)) {
            return false;
        }
        if (this.m_listenees.containsKey("dataSet") && (string.compareTo("trainingSet") == 0 || string.compareTo("testSet") == 0 || string.compareTo("instance") == 0)) {
            return false;
        }
        if ((this.m_listenees.containsKey("trainingSet") || this.m_listenees.containsKey("testSet")) && (string.compareTo("dataSet") == 0 || string.compareTo("instance") == 0)) {
            return false;
        }
        if (this.m_listenees.containsKey("instance") && (string.compareTo("trainingSet") == 0 || string.compareTo("testSet") == 0 || string.compareTo("dataSet") == 0)) {
            return false;
        }
        return string.compareTo("instance") != 0 || this.m_Filter instanceof StreamableFilter;
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string)) {
            this.m_listenees.put(string, object);
            if (this.m_Filter instanceof ConnectionNotificationConsumer) {
                ((ConnectionNotificationConsumer)((Object)this.m_Filter)).connectionNotification(string, object);
            }
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        if (this.m_Filter instanceof ConnectionNotificationConsumer) {
            ((ConnectionNotificationConsumer)((Object)this.m_Filter)).disconnectionNotification(string, object);
        }
        this.m_listenees.remove(string);
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_filterThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public void stop() {
        Enumeration enumeration = this.m_listenees.keys();
        while (enumeration.hasMoreElements()) {
            Object v = this.m_listenees.get(enumeration.nextElement());
            if (!(v instanceof BeanCommon)) continue;
            System.err.println("Listener is BeanCommon");
            ((BeanCommon)v).stop();
        }
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
        if (this.m_Filter != null && this.m_Filter instanceof LogWriter) {
            ((LogWriter)((Object)this.m_Filter)).setLog(this.m_log);
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_filterThread != null) {
            vector.addElement("Stop");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(string + " not supported (Filter)");
        }
        this.stop();
    }

    public boolean eventGeneratable(String string) {
        if (!this.m_listenees.containsKey(string)) {
            return false;
        }
        Object v = this.m_listenees.get(string);
        if (v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable(string)) {
            return false;
        }
        return string.compareTo("instance") != 0 || this.m_Filter instanceof StreamableFilter;
    }
}

