/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallSplitter;

public class PointsClosestToFurthestChildren
extends BallSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -2947177543565818260L;

    public String globalInfo() {
        return "Implements the Moore's method to split a node of a ball tree.\n\nFor more information please see section 2 of the 1st and 3.2.3 of the 2nd:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Andrew W. Moore");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "The Anchors Hierarchy: Using the Triangle Inequality to Survive High Dimensional Data");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2000");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "UAI '00: Proceedings of the 16th Conference on Uncertainty in Artificial Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "397-405");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers Inc.");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "San Francisco, CA, USA");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Ashraf Masood Kibriya");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Nearest Neighbour Search");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2007");
        technicalInformation2.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, School of Computing and Mathematical Sciences, University of Waikato");
        technicalInformation2.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return technicalInformation;
    }

    public PointsClosestToFurthestChildren() {
    }

    public PointsClosestToFurthestChildren(int[] nArray, Instances instances, EuclideanDistance euclideanDistance) {
        super(nArray, instances, euclideanDistance);
    }

    public void splitNode(BallNode ballNode, int n) throws Exception {
        Instance instance;
        int n2;
        this.correctlyInitialized();
        double d = Double.NEGATIVE_INFINITY;
        double d2 = 0.0;
        Instance instance2 = null;
        Instance instance3 = null;
        Instance instance4 = ballNode.getPivot();
        double[] dArray = new double[ballNode.m_NumInstances];
        for (n2 = ballNode.m_Start; n2 <= ballNode.m_End; ++n2) {
            instance = this.m_Instances.instance(this.m_Instlist[n2]);
            d2 = this.m_DistanceFunction.distance(instance4, instance, Double.POSITIVE_INFINITY);
            if (!(d2 > d)) continue;
            d = d2;
            instance2 = instance;
        }
        d = Double.NEGATIVE_INFINITY;
        instance2 = (Instance)instance2.copy();
        for (n2 = 0; n2 < ballNode.m_NumInstances; ++n2) {
            instance = this.m_Instances.instance(this.m_Instlist[n2 + ballNode.m_Start]);
            dArray[n2] = this.m_DistanceFunction.distance(instance2, instance, Double.POSITIVE_INFINITY);
            if (!(dArray[n2] > d)) continue;
            d = dArray[n2];
            instance3 = instance;
        }
        instance3 = (Instance)instance3.copy();
        d2 = 0.0;
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < ballNode.m_NumInstances - n2) {
            instance = this.m_Instances.instance(this.m_Instlist[n3 + ballNode.m_Start]);
            d2 = this.m_DistanceFunction.distance(instance3, instance, Double.POSITIVE_INFINITY);
            if (d2 < dArray[n3]) {
                int n5 = this.m_Instlist[ballNode.m_End - n2];
                this.m_Instlist[ballNode.m_End - n2] = this.m_Instlist[n3 + ballNode.m_Start];
                this.m_Instlist[n3 + ballNode.m_Start] = n5;
                double d3 = dArray[dArray.length - 1 - n2];
                dArray[dArray.length - 1 - n2] = dArray[n3];
                dArray[n3] = d3;
                ++n2;
                --n3;
            }
            ++n3;
            ++n4;
        }
        if (n2 <= 0 || n2 >= ballNode.m_NumInstances) {
            throw new Exception("Illegal value for numRight: " + n2);
        }
        instance4 = BallNode.calcCentroidPivot(ballNode.m_Start, ballNode.m_End - n2, this.m_Instlist, this.m_Instances);
        ballNode.m_Left = new BallNode(ballNode.m_Start, ballNode.m_End - n2, n + 1, instance4, BallNode.calcRadius(ballNode.m_Start, ballNode.m_End - n2, this.m_Instlist, this.m_Instances, instance4, this.m_DistanceFunction));
        instance4 = BallNode.calcCentroidPivot(ballNode.m_End - n2 + 1, ballNode.m_End, this.m_Instlist, this.m_Instances);
        ballNode.m_Right = new BallNode(ballNode.m_End - n2 + 1, ballNode.m_End, n + 2, instance4, BallNode.calcRadius(ballNode.m_End - n2 + 1, ballNode.m_End, this.m_Instlist, this.m_Instances, instance4, this.m_DistanceFunction));
    }
}

