/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class AddValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private static final long serialVersionUID = -8100622241742393656L;
    protected SingleIndex m_AttIndex = new SingleIndex("last");
    protected Vector m_Labels = new Vector();
    protected boolean m_Sort = false;
    protected int[] m_SortedIndices;

    public String globalInfo() {
        return "Adds the labels from the given list to an attribute if they are missing. The labels can also be sorted in an ascending manner. If no labels are provided then only the (optional) sorting applies.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSets the attribute index\n\t(default last).", "C", 1, "-C <col>"));
        result.addElement(new Option("\tComma-separated list of labels to add.\n\t(default: none)", "L", 1, "-L <label1,label2,...>"));
        result.addElement(new Option("\tTurns on the sorting of the labels.", "S", 0, "-S"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndex(tmpStr);
        } else {
            this.setAttributeIndex("last");
        }
        tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.setLabels(tmpStr);
        } else {
            this.setLabels("");
        }
        this.setSort(Utils.getFlag('S', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-C");
        result.add("" + this.getAttributeIndex());
        result.add("-L");
        result.add("" + this.getLabels());
        if (this.getSort()) {
            result.add("-S");
        }
        return result.toArray(new String[result.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        int i;
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        Attribute att = instanceInfo.attribute(this.m_AttIndex.getIndex());
        if (!att.isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        Vector allLabels = new Vector();
        Enumeration enm = att.enumerateValues();
        while (enm.hasMoreElements()) {
            allLabels.add(enm.nextElement());
        }
        for (i = 0; i < this.m_Labels.size(); ++i) {
            if (allLabels.contains(this.m_Labels.get(i))) continue;
            allLabels.add(this.m_Labels.get(i));
        }
        if (this.getSort()) {
            Collections.sort(allLabels);
        }
        this.m_SortedIndices = new int[att.numValues()];
        enm = att.enumerateValues();
        i = 0;
        while (enm.hasMoreElements()) {
            this.m_SortedIndices[i] = allLabels.indexOf(enm.nextElement());
            ++i;
        }
        FastVector<String> values = new FastVector<String>();
        for (i = 0; i < allLabels.size(); ++i) {
            values.addElement((String)allLabels.get(i));
        }
        Attribute attNew = new Attribute(att.name(), values);
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (i = 0; i < instanceInfo.numAttributes(); ++i) {
            if (i == this.m_AttIndex.getIndex()) {
                atts.addElement(attNew);
                continue;
            }
            atts.addElement(instanceInfo.attribute(i));
        }
        Instances instNew = new Instances(instanceInfo.relationName(), atts, 0);
        instNew.setClassIndex(instanceInfo.classIndex());
        this.setOutputFormat(instNew);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] values = instance.toDoubleArray();
        if (!instance.isMissing(this.m_AttIndex.getIndex())) {
            values[this.m_AttIndex.getIndex()] = this.m_SortedIndices[(int)values[this.m_AttIndex.getIndex()]];
        }
        DenseInstance newInstance = new DenseInstance(instance.weight(), values);
        this.copyValues(instance, false, instance.dataset(), this.getOutputFormat());
        this.push(newInstance);
        return true;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be nominal (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public String labelsTipText() {
        return "Comma-separated list of lables to add.";
    }

    public String getLabels() {
        String result = "";
        for (int i = 0; i < this.m_Labels.size(); ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + Utils.quote((String)this.m_Labels.get(i));
        }
        return result;
    }

    public void setLabels(String value) {
        this.m_Labels.clear();
        String label = "";
        boolean quoted = false;
        boolean add = false;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\"') {
                boolean bl = quoted = !quoted;
                if (!quoted) {
                    add = true;
                }
            } else if (value.charAt(i) == ',' && !quoted) {
                add = true;
            } else {
                label = label + value.charAt(i);
                if (i == value.length() - 1) {
                    add = true;
                }
            }
            if (!add) continue;
            if (label.length() != 0) {
                this.m_Labels.add(label);
            }
            label = "";
            add = false;
        }
    }

    public String sortTipText() {
        return "Whether to sort the labels alphabetically.";
    }

    public boolean getSort() {
        return this.m_Sort;
    }

    public void setSort(boolean value) {
        this.m_Sort = value;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6898 $");
    }

    public static void main(String[] args) {
        AddValues.runFilter(new AddValues(), args);
    }
}

