/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.Remove;

public class PartitionedMultiFilter
extends SimpleBatchFilter {
    private static final long serialVersionUID = -6293720886005713120L;
    protected Filter[] m_Filters = new Filter[]{new AllFilter()};
    protected Range[] m_Ranges = new Range[]{new Range("first-last")};
    protected boolean m_RemoveUnused = false;
    protected int[] m_IndicesUnused = new int[0];

    public String globalInfo() {
        return "A filter that applies filters on subsets of attributes and assembles the output into a new dataset. Attributes that are not covered by any of the ranges can be either retained or removed from the output.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tA filter to apply (can be specified multiple times).", "F", 1, "-F <classname [options]>"));
        result.addElement(new Option("\tAn attribute range (can be specified multiple times).\n\tFor each filter a range must be supplied. 'first' and 'last'\n\tare valid indices. 'inv(...)' around the range denotes an\n\tinverted range.", "R", 1, "-R <range>"));
        result.addElement(new Option("\tFlag for leaving unused attributes out of the output, by default\n\tthese are included in the filter output.", "U", 0, "-U"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        super.setOptions(options);
        this.setRemoveUnused(Utils.getFlag("U", options));
        Vector<Object> objects = new Vector<Object>();
        while ((tmpStr = Utils.getOption("F", options)).length() != 0) {
            String[] options2 = Utils.splitOptions(tmpStr);
            String classname = options2[0];
            options2[0] = "";
            objects.add(Utils.forName(Filter.class, classname, options2));
        }
        if (objects.size() == 0) {
            objects.add(new AllFilter());
        }
        this.setFilters(objects.toArray(new Filter[objects.size()]));
        objects = new Vector();
        while ((tmpStr = Utils.getOption("R", options)).length() != 0) {
            Range range;
            if (tmpStr.startsWith("inv(") && tmpStr.endsWith(")")) {
                range = new Range(tmpStr.substring(4, tmpStr.length() - 1));
                range.setInvert(true);
            } else {
                range = new Range(tmpStr);
            }
            objects.add(range);
        }
        if (objects.size() == 0) {
            objects.add(new Range("first-last"));
        }
        this.setRanges(objects.toArray(new Range[objects.size()]));
        this.checkDimensions();
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getRemoveUnused()) {
            result.add("-U");
        }
        for (i = 0; i < this.getFilters().length; ++i) {
            result.add("-F");
            result.add(this.getFilterSpec(this.getFilter(i)));
        }
        for (i = 0; i < this.getRanges().length; ++i) {
            String tmpStr = this.getRange(i).getRanges();
            if (this.getRange(i).getInvert()) {
                tmpStr = "inv(" + tmpStr + ")";
            }
            result.add("-R");
            result.add(tmpStr);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void checkDimensions() throws Exception {
        if (this.getFilters().length != this.getRanges().length) {
            throw new IllegalArgumentException("Number of filters (= " + this.getFilters().length + ") " + "and ranges (= " + this.getRanges().length + ") don't match!");
        }
    }

    protected void testInputFormat(Instances instanceInfo) throws Exception {
        for (int i = 0; i < this.getRanges().length; ++i) {
            Instances newi = new Instances(instanceInfo, 0);
            if (instanceInfo.size() > 0) {
                newi.add((Instance)instanceInfo.get(0).copy());
            }
            Range range = this.getRanges()[i];
            range.setUpper(instanceInfo.numAttributes() - 1);
            Instances subset = this.generateSubset(newi, range);
            this.getFilters()[i].setInputFormat(subset);
        }
    }

    public void setRemoveUnused(boolean value) {
        this.m_RemoveUnused = value;
    }

    public boolean getRemoveUnused() {
        return this.m_RemoveUnused;
    }

    public String removeUnusedTipText() {
        return "If true then unused attributes (ones that are not covered by any of the ranges) will be removed from the output.";
    }

    public void setFilters(Filter[] filters) {
        this.m_Filters = filters;
        this.reset();
    }

    public Filter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The base filters to be used.";
    }

    public Filter getFilter(int index) {
        return this.m_Filters[index];
    }

    protected String getFilterSpec(Filter filter) {
        String result;
        if (filter == null) {
            result = "";
        } else {
            result = filter.getClass().getName();
            if (filter instanceof OptionHandler) {
                result = result + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
            }
        }
        return result;
    }

    public void setRanges(Range[] Ranges) {
        this.m_Ranges = Ranges;
        this.reset();
    }

    public Range[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The attribute ranges to be used; 'inv(...)' denotes an inverted range.";
    }

    public Range getRange(int index) {
        return this.m_Ranges[index];
    }

    protected void determineUnusedIndices(Instances data) {
        int i;
        Vector<Integer> indices = new Vector<Integer>();
        for (i = 0; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) continue;
            boolean covered = false;
            for (int n = 0; n < this.getRanges().length; ++n) {
                if (!this.getRanges()[n].isInRange(i)) continue;
                covered = true;
                break;
            }
            if (covered) continue;
            indices.add(new Integer(i));
        }
        this.m_IndicesUnused = new int[indices.size()];
        for (i = 0; i < indices.size(); ++i) {
            this.m_IndicesUnused[i] = (Integer)indices.get(i);
        }
        if (this.getDebug()) {
            System.out.println("Unused indices: " + Utils.arrayToString(this.m_IndicesUnused));
        }
    }

    protected Instances generateSubset(Instances data, Range range) throws Exception {
        int[] indices = range.getSelection();
        StringBuilder atts = new StringBuilder();
        for (int i = 0; i < indices.length; ++i) {
            if (i > 0) {
                atts.append(",");
            }
            atts.append("" + (indices[i] + 1));
        }
        if (data.classIndex() > -1 && !range.isInRange(data.classIndex())) {
            atts.append("," + (data.classIndex() + 1));
        }
        Remove filter = new Remove();
        filter.setAttributeIndices(atts.toString());
        filter.setInvertSelection(true);
        filter.setInputFormat(data);
        Instances result = Filter.useFilter(data, filter);
        return result;
    }

    protected Instances renameAttributes(Instances data, String prefix) throws Exception {
        int i;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) {
                atts.add((Attribute)data.attribute(i).copy());
                continue;
            }
            atts.add(data.attribute(i).copy(prefix + data.attribute(i).name()));
        }
        Instances result = new Instances(data.relationName(), atts, data.numInstances());
        for (i = 0; i < data.numInstances(); ++i) {
            result.add((Instance)data.instance(i).copy());
        }
        if (data.classIndex() > -1) {
            result.setClassIndex(data.classIndex());
        }
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Instances result;
        if (!this.isFirstBatchDone()) {
            int i;
            if (inputFormat.numInstances() == 0) {
                return null;
            }
            this.checkDimensions();
            this.determineUnusedIndices(inputFormat);
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (i = 0; i < this.getFilters().length; ++i) {
                Instances processed;
                if (!this.isFirstBatchDone()) {
                    processed = this.generateSubset(inputFormat, this.getRange(i));
                    if (!this.getFilter(i).setInputFormat(processed)) {
                        Filter.useFilter(processed, this.getFilter(i));
                    }
                }
                processed = this.getFilter(i).getOutputFormat();
                processed = this.renameAttributes(processed, "filtered-" + i + "-");
                for (int n = 0; n < processed.numAttributes(); ++n) {
                    if (n == processed.classIndex()) continue;
                    atts.add((Attribute)processed.attribute(n).copy());
                }
            }
            if (!this.getRemoveUnused()) {
                for (i = 0; i < this.m_IndicesUnused.length; ++i) {
                    Attribute att = inputFormat.attribute(this.m_IndicesUnused[i]);
                    atts.add(att.copy("unfiltered-" + att.name()));
                }
            }
            if (inputFormat.classIndex() > -1) {
                atts.add((Attribute)inputFormat.classAttribute().copy());
            }
            result = new Instances(inputFormat.relationName(), atts, 0);
            if (inputFormat.classIndex() > -1) {
                result.setClassIndex(result.numAttributes() - 1);
            }
        } else {
            result = this.getOutputFormat();
        }
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result;
        int i;
        if (!this.isFirstBatchDone()) {
            this.checkDimensions();
            for (i = 0; i < this.m_Ranges.length; ++i) {
                this.m_Ranges[i].setUpper(instances.numAttributes() - 1);
            }
            this.determineUnusedIndices(instances);
        }
        Instances[] processed = new Instances[this.getFilters().length];
        for (i = 0; i < this.getFilters().length; ++i) {
            processed[i] = this.generateSubset(instances, this.getRange(i));
            if (!this.isFirstBatchDone()) {
                this.getFilter(i).setInputFormat(processed[i]);
            }
            processed[i] = Filter.useFilter(processed[i], this.getFilter(i));
        }
        if (!this.isFirstBatchDone()) {
            result = this.determineOutputFormat(instances);
            this.setOutputFormat(result);
        } else {
            result = this.getOutputFormat();
        }
        Vector<Integer> errors = new Vector<Integer>();
        for (i = 0; i < processed.length; ++i) {
            if (processed[i].numInstances() == instances.numInstances()) continue;
            errors.add(new Integer(i));
        }
        if (errors.size() > 0) {
            throw new IllegalStateException("The following filter(s) changed the number of instances: " + errors);
        }
        for (i = 0; i < instances.numInstances(); ++i) {
            int n;
            Instance inst = instances.instance(i);
            double[] values = new double[result.numAttributes()];
            int index = 0;
            for (n = 0; n < processed.length; ++n) {
                for (int m = 0; m < processed[n].numAttributes(); ++m) {
                    if (m == processed[n].classIndex()) continue;
                    values[index] = result.attribute(index).isString() ? (double)result.attribute(index).addStringValue(processed[n].instance(i).stringValue(m)) : (result.attribute(index).isRelationValued() ? (double)result.attribute(index).addRelation(processed[n].instance(i).relationalValue(m)) : processed[n].instance(i).value(m));
                    ++index;
                }
            }
            if (!this.getRemoveUnused()) {
                for (n = 0; n < this.m_IndicesUnused.length; ++n) {
                    values[index] = result.attribute(index).isString() ? (double)result.attribute(index).addStringValue(inst.stringValue(this.m_IndicesUnused[n])) : (result.attribute(index).isRelationValued() ? (double)result.attribute(index).addRelation(inst.relationalValue(this.m_IndicesUnused[n])) : inst.value(this.m_IndicesUnused[n]));
                    ++index;
                }
            }
            if (instances.classIndex() > -1) {
                values[values.length - 1] = inst.value(instances.classIndex());
            }
            AbstractInstance newInst = inst instanceof SparseInstance ? new SparseInstance(instances.instance(i).weight(), values) : new DenseInstance(instances.instance(i).weight(), values);
            result.add(newInst);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7505 $");
    }

    public static void main(String[] args) {
        PartitionedMultiFilter.runFilter(new PartitionedMultiFilter(), args);
    }
}

