/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import javax.swing.JOptionPane;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Memory
implements RevisionHandler {
    protected static boolean m_Enabled = true;
    protected boolean m_UseGUI = false;
    protected static long m_Initial = Runtime.getRuntime().totalMemory();
    protected long m_Total;
    protected long m_Max;
    protected Runtime m_Runtime;

    public Memory() {
        this(false);
    }

    public Memory(boolean useGUI) {
        this.m_UseGUI = useGUI;
        this.m_Runtime = Runtime.getRuntime();
        this.m_Max = this.m_Runtime.maxMemory();
        this.m_Total = this.m_Runtime.totalMemory();
    }

    public boolean isEnabled() {
        return m_Enabled;
    }

    public void setEnabled(boolean value) {
        m_Enabled = value;
    }

    public boolean getUseGUI() {
        return this.m_UseGUI;
    }

    public long getInitial() {
        return m_Initial;
    }

    public long getCurrent() {
        this.m_Runtime = Runtime.getRuntime();
        this.m_Total = this.m_Runtime.totalMemory();
        return this.m_Total;
    }

    public long getMax() {
        return this.m_Max;
    }

    public boolean isOutOfMemory() {
        if (this.isEnabled()) {
            return this.getMax() - this.getCurrent() < this.getInitial() + 200000L;
        }
        return false;
    }

    public static double toMegaByte(long bytes) {
        return (double)bytes / 1048576.0;
    }

    public void showOutOfMemory() {
        if (!this.isEnabled()) {
            return;
        }
        System.gc();
        String msg = "Not enough memory. Please load a smaller dataset or use larger heap size.\n- initial JVM size:   " + Utils.doubleToString(Memory.toMegaByte(m_Initial), 1) + "MB\n" + "- total memory used:  " + Utils.doubleToString(Memory.toMegaByte(this.m_Total), 1) + "MB\n" + "- max. memory avail.: " + Utils.doubleToString(Memory.toMegaByte(this.m_Max), 1) + "MB\n" + "\n" + "Note:\n" + "The Java heap size can be specified with the -Xmx option.\n" + "E.g., to use 128MB as heap size, the command line looks like this:\n" + "   java -Xmx128m -classpath ...\n" + "This does NOT work in the SimpleCLI, the java command refers\n" + "to the one with which Weka is started.";
        System.err.println(msg);
        if (this.getUseGUI()) {
            JOptionPane.showMessageDialog(null, msg, "OutOfMemory", 2);
        }
    }

    public void stopThreads() {
        Thread[] thGroup = new Thread[Thread.activeCount()];
        Thread.enumerate(thGroup);
        for (int i = 0; i < thGroup.length; ++i) {
            Thread t = thGroup[i];
            if (t == null || t == Thread.currentThread()) continue;
            if (t.getName().startsWith("Thread")) {
                t.stop();
                continue;
            }
            if (!t.getName().startsWith("AWT-EventQueue")) continue;
            t.stop();
        }
        thGroup = null;
        System.gc();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        Memory mem = new Memory();
        System.out.println("Initial memory: " + Utils.doubleToString(Memory.toMegaByte(mem.getInitial()), 1) + "MB" + " (" + mem.getInitial() + ")");
        System.out.println("Max memory: " + Utils.doubleToString(Memory.toMegaByte(mem.getMax()), 1) + "MB" + " (" + mem.getMax() + ")");
    }
}

