/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class AddID
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 4734383199819293390L;
    protected SingleIndex m_Index = new SingleIndex("first");
    protected String m_Name = "ID";
    protected int m_Counter = -1;

    public String globalInfo() {
        return "An instance filter that adds an ID attribute to the dataset. The new attribute contains a unique ID for each instance.\nNote: The ID is not reset for the second batch of files (using -b and -r and -s).";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecify where to insert the ID. First and last\n\tare valid indexes.(default first)", "C", 1, "-C <index>"));
        result.addElement(new Option("\tName of the new attribute.\n\t(default = 'ID')", "N", 1, "-N <name>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.m_Index.setSingleIndex(tmpStr);
        } else {
            this.m_Index.setSingleIndex("first");
        }
        tmpStr = Utils.getOption('N', options);
        this.m_Name = tmpStr.length() != 0 ? tmpStr : "ID";
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-C");
        result.add(this.getIDIndex());
        result.add("-N");
        result.add(this.getAttributeName());
        return result.toArray(new String[result.size()]);
    }

    public String attributeNameTipText() {
        return "Set the new attribute's name.";
    }

    public String getAttributeName() {
        return this.m_Name;
    }

    public void setAttributeName(String value) {
        this.m_Name = value;
    }

    public String IDIndexTipText() {
        return "The position (starting from 1) where the attribute will be inserted (first and last are valid indices).";
    }

    public String getIDIndex() {
        return this.m_Index.getSingleIndex();
    }

    public void setIDIndex(String value) {
        this.m_Index.setSingleIndex(value);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_Counter = -1;
        this.m_Index.setUpper(instanceInfo.numAttributes());
        Instances outputFormat = new Instances(instanceInfo, 0);
        Attribute newAttribute = new Attribute(this.m_Name);
        if (this.m_Index.getIndex() < 0 || this.m_Index.getIndex() > this.getInputFormat().numAttributes()) {
            throw new IllegalArgumentException("Index out of range");
        }
        outputFormat.insertAttributeAt(newAttribute, this.m_Index.getIndex());
        this.setOutputFormat(outputFormat);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!this.isFirstBatchDone()) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.m_Counter = 0;
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    protected void convertInstance(Instance instance) {
        ++this.m_Counter;
        try {
            Instance inst = (Instance)instance.copy();
            this.copyValues(inst, true, inst.dataset(), this.getOutputFormat());
            inst.setDataset(null);
            inst.insertAttributeAt(this.m_Index.getIndex());
            inst.setValue(this.m_Index.getIndex(), (double)this.m_Counter);
            inst.setDataset(this.getOutputFormat());
            this.push(inst);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        AddID.runFilter(new AddID(), args);
    }
}

