/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.core.Instance;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class BayesNetEstimator
implements OptionHandler,
Serializable,
RevisionHandler {
    static final long serialVersionUID = 2184330197666253884L;
    protected double m_fAlpha = 0.5;

    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        throw new Exception("Incorrect BayesNetEstimator: use subclass instead.");
    }

    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("Incorrect BayesNetEstimator: use subclass instead.");
    }

    public double[] distributionForInstance(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("Incorrect BayesNetEstimator: use subclass instead.");
    }

    public void initCPTs(BayesNet bayesNet) throws Exception {
        throw new Exception("Incorrect BayesNetEstimator: use subclass instead.");
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tInitial count (alpha)\n", "A", 1, "-A <alpha>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String sAlpha = Utils.getOption('A', options);
        this.m_fAlpha = sAlpha.length() != 0 ? (double)new Float(sAlpha).floatValue() : 0.5;
        Utils.checkForRemainingOptions(options);
    }

    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        options[current++] = "-A";
        options[current++] = "" + this.m_fAlpha;
        return options;
    }

    public void setAlpha(double fAlpha) {
        this.m_fAlpha = fAlpha;
    }

    public double getAlpha() {
        return this.m_fAlpha;
    }

    public String alphaTipText() {
        return "Alpha is used for estimating the probability tables and can be interpreted as the initial count on each value.";
    }

    public String globalInfo() {
        return "BayesNetEstimator is the base class for estimating the conditional probability tables of a Bayes network once the structure has been learned.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

