/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.AbstractDensityBasedClusterer;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.Utils;

public abstract class RandomizableDensityBasedClusterer
extends AbstractDensityBasedClusterer
implements OptionHandler,
Randomizable {
    private static final long serialVersionUID = -5325270357918932849L;
    protected int m_SeedDefault;
    protected int m_Seed;

    public RandomizableDensityBasedClusterer() {
        this.m_Seed = this.m_SeedDefault = 1;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tRandom number seed.\n\t(default " + this.m_SeedDefault + ")", "S", 1, "-S <num>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(this.m_SeedDefault);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-S");
        result.add("" + this.getSeed());
        return result.toArray(new String[result.size()]);
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int value) {
        this.m_Seed = value;
    }

    public int getSeed() {
        return this.m_Seed;
    }
}

