/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.gui.ComponentHelper;
import weka.gui.JTableHelper;
import weka.gui.ViewerDialog;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTableCellRenderer;

public class ArffTable
extends JTable {
    static final long serialVersionUID = -2016200506908637967L;
    private String m_SearchString;
    private HashSet m_ChangeListeners;

    public ArffTable() {
        this(new ArffSortedTableModel("", new AbstractFileLoader[0]));
    }

    public ArffTable(TableModel model) {
        super(model);
        this.setAutoResizeMode(0);
    }

    public void setModel(TableModel model) {
        this.m_SearchString = null;
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet();
        }
        super.setModel(model);
        if (model == null) {
            return;
        }
        if (!(model instanceof ArffSortedTableModel)) {
            return;
        }
        ArffSortedTableModel arffModel = (ArffSortedTableModel)model;
        arffModel.addMouseListenerToHeader(this);
        arffModel.addTableModelListener(this);
        arffModel.sort(0);
        this.setLayout();
        this.setSelectedColumn(0);
        if (this.getTableHeader() != null) {
            this.getTableHeader().setReorderingAllowed(false);
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor result = this.getModel() instanceof ArffSortedTableModel && ((ArffSortedTableModel)this.getModel()).getType(column) == 4 ? new RelationalCellEditor(row, column) : super.getCellEditor(row, column);
        return result;
    }

    public boolean isReadOnly() {
        return ((ArffSortedTableModel)this.getModel()).isReadOnly();
    }

    public void setReadOnly(boolean value) {
        ((ArffSortedTableModel)this.getModel()).setReadOnly(value);
    }

    private void setLayout() {
        ArffSortedTableModel arffModel = (ArffSortedTableModel)this.getModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            JTableHelper.setOptimalHeaderWidth(this, i);
            this.getColumnModel().getColumn(i).setCellRenderer(new ArffTableCellRenderer());
            if (i <= 0) continue;
            if (arffModel.getType(i) == 1) {
                JComboBox combo = new JComboBox();
                combo.addItem(null);
                Enumeration enm = arffModel.getInstances().attribute(i - 1).enumerateValues();
                while (enm.hasMoreElements()) {
                    combo.addItem(enm.nextElement());
                }
                this.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(combo));
                continue;
            }
            this.getColumnModel().getColumn(i).setCellEditor(null);
        }
    }

    public String getPlainColumnName(int columnIndex) {
        String result = "";
        if (this.getModel() == null) {
            return result;
        }
        if (!(this.getModel() instanceof ArffSortedTableModel)) {
            return result;
        }
        ArffSortedTableModel arffModel = (ArffSortedTableModel)this.getModel();
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? "No." : arffModel.getAttributeAt(columnIndex).name();
        }
        return result;
    }

    public StringSelection getStringSelection() {
        int i;
        int[] indices;
        StringSelection result = null;
        if (this.getSelectedRow() == -1) {
            if (ComponentHelper.showMessageBox(this.getParent(), "Question...", "Do you really want to copy the whole table?", 0, 3) != 0) {
                return result;
            }
            indices = new int[this.getRowCount()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
        } else {
            indices = this.getSelectedRows();
        }
        StringBuffer tmp = new StringBuffer();
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (i > 0) {
                tmp.append("\t");
            }
            tmp.append(this.getPlainColumnName(i));
        }
        tmp.append("\n");
        for (i = 0; i < indices.length; ++i) {
            for (int n = 0; n < this.getColumnCount(); ++n) {
                if (n > 0) {
                    tmp.append("\t");
                }
                tmp.append(this.getValueAt(indices[i], n).toString());
            }
            tmp.append("\n");
        }
        result = new StringSelection(tmp.toString());
        return result;
    }

    public void setSearchString(String searchString) {
        this.m_SearchString = searchString;
        this.repaint();
    }

    public String getSearchString() {
        return this.m_SearchString;
    }

    public void setSelectedColumn(int index) {
        this.getColumnModel().getSelectionModel().clearSelection();
        this.getColumnModel().getSelectionModel().setSelectionInterval(index, index);
        this.resizeAndRepaint();
        if (this.getTableHeader() != null) {
            this.getTableHeader().resizeAndRepaint();
        }
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        this.setLayout();
        this.notifyListener();
    }

    private void notifyListener() {
        Iterator iter = this.m_ChangeListeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected class RelationalCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 657969163293205963L;
        protected JButton m_Button;
        protected Instances m_CurrentInst;
        protected int m_RowIndex;
        protected int m_ColumnIndex;

        public RelationalCellEditor(int rowIndex, int columnIndex) {
            this.m_CurrentInst = this.getInstancesAt(rowIndex, columnIndex);
            this.m_RowIndex = rowIndex;
            this.m_ColumnIndex = columnIndex;
            this.m_Button = new JButton("...");
            this.m_Button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ViewerDialog dialog = new ViewerDialog(null);
                    dialog.setTitle("Relational attribute Viewer - " + ((ArffSortedTableModel)ArffTable.this.getModel()).getInstances().attribute(RelationalCellEditor.this.m_ColumnIndex - 1).name());
                    int result = dialog.showDialog(RelationalCellEditor.this.m_CurrentInst);
                    if (result == 0) {
                        RelationalCellEditor.this.m_CurrentInst = dialog.getInstances();
                        RelationalCellEditor.this.fireEditingStopped();
                    } else {
                        RelationalCellEditor.this.fireEditingCanceled();
                    }
                }
            });
        }

        protected Instances getInstancesAt(int rowIndex, int columnIndex) {
            ArffSortedTableModel model = (ArffSortedTableModel)ArffTable.this.getModel();
            double value = model.getInstancesValueAt(rowIndex, columnIndex);
            Instances result = model.getInstances().attribute(columnIndex - 1).relation((int)value);
            return result;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.m_Button;
        }

        public Object getCellEditorValue() {
            return this.m_CurrentInst;
        }
    }
}

