/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class RandomProjection
extends Filter
implements UnsupervisedFilter,
OptionHandler,
TechnicalInformationHandler,
Randomizable,
WeightedInstancesHandler {
    static final long serialVersionUID = 4428905532728645880L;
    protected int m_k = 10;
    protected double m_percent = 0.0;
    public static final int SPARSE1 = 1;
    public static final int SPARSE2 = 2;
    public static final int GAUSSIAN = 3;
    public static final Tag[] TAGS_DSTRS_TYPE = new Tag[]{new Tag(1, "Sparse1"), new Tag(2, "Sparse2"), new Tag(3, "Gaussian")};
    protected int m_distribution = 1;
    protected boolean m_useReplaceMissing = false;
    protected boolean m_OutputFormatDefined = false;
    protected Filter m_ntob;
    protected Filter m_replaceMissing;
    protected int m_rndmSeed = 42;
    protected double[][] m_rmatrix;
    protected Random m_random;
    private static final int[] weights = new int[]{1, 1, 4};
    private static final int[] vals = new int[]{-1, 1, 0};
    private static final int[] weights2 = new int[]{1, 1};
    private static final int[] vals2 = new int[]{-1, 1};
    private static final double sqrt3 = Math.sqrt(3.0);

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(5);
        newVector.addElement(new Option("\tThe number of dimensions (attributes) the data should be reduced to\n\t(default 10; exclusive of the class attribute, if it is set).", "N", 1, "-N <number>"));
        newVector.addElement(new Option("\tThe distribution to use for calculating the random matrix.\n\tSparse1 is:\n\t  sqrt(3)*{-1 with prob(1/6), 0 with prob(2/3), +1 with prob(1/6)}\n\tSparse2 is:\n\t  {-1 with prob(1/2), +1 with prob(1/2)}", "D", 1, "-D [SPARSE1|SPARSE2|GAUSSIAN]"));
        newVector.addElement(new Option("\tThe percentage of dimensions (attributes) the data should\n\tbe reduced to (exclusive of the class attribute, if it is set). The -N\n\toption is ignored if this option is present and is greater\n\tthan zero.", "P", 1, "-P <percent>"));
        newVector.addElement(new Option("\tReplace missing values using the ReplaceMissingValues filter instead of just skipping them.", "M", 0, "-M"));
        newVector.addElement(new Option("\tThe random seed for the random number generator used for\n\tcalculating the random matrix (default 42).", "R", 0, "-R <num>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String mString = Utils.getOption('P', options);
        if (mString.length() != 0) {
            this.setPercent(Double.parseDouble(mString));
        } else {
            this.setPercent(0.0);
            mString = Utils.getOption('N', options);
            if (mString.length() != 0) {
                this.setNumberOfAttributes(Integer.parseInt(mString));
            } else {
                this.setNumberOfAttributes(10);
            }
        }
        mString = Utils.getOption('R', options);
        if (mString.length() != 0) {
            this.setSeed(Integer.parseInt(mString));
        }
        if ((mString = Utils.getOption('D', options)).length() != 0) {
            if (mString.equalsIgnoreCase("sparse1")) {
                this.setDistribution(new SelectedTag(1, TAGS_DSTRS_TYPE));
            } else if (mString.equalsIgnoreCase("sparse2")) {
                this.setDistribution(new SelectedTag(2, TAGS_DSTRS_TYPE));
            } else if (mString.equalsIgnoreCase("gaussian")) {
                this.setDistribution(new SelectedTag(3, TAGS_DSTRS_TYPE));
            }
        }
        if (Utils.getFlag('M', options)) {
            this.setReplaceMissingValues(true);
        } else {
            this.setReplaceMissingValues(false);
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getReplaceMissingValues()) {
            options.add("-M");
        }
        if (this.getPercent() <= 0.0) {
            options.add("-N");
            options.add("" + this.getNumberOfAttributes());
        } else {
            options.add("-P");
            options.add("" + this.getPercent());
        }
        options.add("-R");
        options.add("" + this.getSeed());
        SelectedTag t = this.getDistribution();
        options.add("-D");
        options.add("" + t.getSelectedTag().getReadable());
        return options.toArray(new String[0]);
    }

    public String globalInfo() {
        return "Reduces the dimensionality of the data by projecting it onto a lower dimensional subspace using a random matrix with columns of unit length. It will reduce the number of attributes in the data while preserving much of its variation like PCA, but at a much less computational cost.\nIt first applies the NominalToBinary filter to convert all attributes to numeric before reducing the dimension. It preserves the class attribute.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Dmitriy Fradkin and David Madigan");
        result.setValue(TechnicalInformation.Field.TITLE, "Experiments with random projections for machine learning");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "KDD '03: Proceedings of the ninth ACM SIGKDD International Conference on Knowledge Discovery and Data mining");
        result.setValue(TechnicalInformation.Field.YEAR, "003");
        result.setValue(TechnicalInformation.Field.PAGES, "517-522");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        result.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY, USA");
        return result;
    }

    public String numberOfAttributesTipText() {
        return "The number of dimensions (attributes) the data should be reduced to.";
    }

    public void setNumberOfAttributes(int newAttNum) {
        this.m_k = newAttNum;
    }

    public int getNumberOfAttributes() {
        return this.m_k;
    }

    public String percentTipText() {
        return " The percentage of dimensions (attributes) the data should be reduced to  (inclusive of the class attribute). The  NumberOfAttributes option is ignored if this option is present or is greater than zero.";
    }

    public void setPercent(double newPercent) {
        if (newPercent > 0.0) {
            newPercent /= 100.0;
        }
        this.m_percent = newPercent;
    }

    public double getPercent() {
        return this.m_percent * 100.0;
    }

    public String seedTipText() {
        return "The random seed used by the random number generator used for generating the random matrix ";
    }

    @Override
    public void setSeed(int seed) {
        this.m_rndmSeed = seed;
    }

    @Override
    public int getSeed() {
        return this.m_rndmSeed;
    }

    public String distributionTipText() {
        return "The distribution to use for calculating the random matrix.\nSparse1 is:\n sqrt(3) * { -1 with prob(1/6), \n               0 with prob(2/3),  \n              +1 with prob(1/6) } \nSparse2 is:\n { -1 with prob(1/2), \n   +1 with prob(1/2) } ";
    }

    public void setDistribution(SelectedTag newDstr) {
        if (newDstr.getTags() == TAGS_DSTRS_TYPE) {
            this.m_distribution = newDstr.getSelectedTag().getID();
        }
    }

    public SelectedTag getDistribution() {
        return new SelectedTag(this.m_distribution, TAGS_DSTRS_TYPE);
    }

    public String replaceMissingValuesTipText() {
        return "If set the filter uses weka.filters.unsupervised.attribute.ReplaceMissingValues to replace the missing values instead of just skipping them.";
    }

    public void setReplaceMissingValues(boolean t) {
        this.m_useReplaceMissing = t;
    }

    public boolean getReplaceMissingValues() {
        return this.m_useReplaceMissing;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_ntob = instanceInfo.classIndex() >= 0 ? new weka.filters.supervised.attribute.NominalToBinary() : new NominalToBinary();
        this.m_replaceMissing = null;
        this.m_OutputFormatDefined = false;
        if (this.getReplaceMissingValues()) {
            this.m_replaceMissing = new ReplaceMissingValues();
            this.m_replaceMissing.setInputFormat(instanceInfo);
            if (this.m_ntob.setInputFormat(this.m_replaceMissing.getOutputFormat())) {
                this.setOutputFormat();
                return true;
            }
            return false;
        }
        if (this.m_ntob.setInputFormat(instanceInfo)) {
            this.setOutputFormat();
            return true;
        }
        return false;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_OutputFormatDefined && (!this.m_useReplaceMissing || this.isFirstBatchDone())) {
            if (this.m_replaceMissing != null) {
                this.m_replaceMissing.input(instance);
                instance = this.m_replaceMissing.output();
            }
            this.m_ntob.input(instance);
            instance = this.m_ntob.output();
            this.push(this.convertInstance(instance), false);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        Instances insts = this.getInputFormat();
        if (this.m_useReplaceMissing) {
            insts = Filter.useFilter(insts, this.m_replaceMissing);
        }
        insts = Filter.useFilter(insts, this.m_ntob);
        if (!this.m_OutputFormatDefined) {
            this.setOutputFormat();
        }
        for (Instance instance : insts) {
            this.push(this.convertInstance(instance), false);
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    protected void setOutputFormat() throws Exception {
        Instances currentFormat = this.m_ntob.getOutputFormat();
        if (this.m_percent > 0.0) {
            this.m_k = (int)((double)(this.getInputFormat().numAttributes() - 1) * this.m_percent);
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < this.m_k; ++i) {
            attributes.add(new Attribute("K" + (i + 1)));
        }
        if (this.getInputFormat().classIndex() > -1) {
            attributes.add((Attribute)this.getInputFormat().classAttribute().copy());
        }
        Instances newFormat = new Instances(currentFormat.relationName(), attributes, 0);
        if (this.getInputFormat().classIndex() > -1) {
            newFormat.setClassIndex(attributes.size() - 1);
        }
        this.m_random = new Random(this.m_rndmSeed);
        this.m_rmatrix = new double[this.m_k][currentFormat.numAttributes()];
        if (this.m_distribution == 3) {
            for (int i = 0; i < this.m_rmatrix.length; ++i) {
                for (int j = 0; j < this.m_rmatrix[i].length; ++j) {
                    this.m_rmatrix[i][j] = this.m_random.nextGaussian();
                }
            }
        } else {
            boolean useDstrWithZero = this.m_distribution == 1;
            for (int i = 0; i < this.m_rmatrix.length; ++i) {
                for (int j = 0; j < this.m_rmatrix[i].length; ++j) {
                    this.m_rmatrix[i][j] = this.rndmNum(useDstrWithZero);
                }
            }
        }
        this.m_OutputFormatDefined = true;
        this.setOutputFormat(newFormat);
    }

    protected Instance convertInstance(Instance instance) throws Exception {
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        for (int j = 0; j < this.m_k; ++j) {
            for (int i = 0; i < instance.numValues(); ++i) {
                int index = instance.index(i);
                if (index != instance.classIndex()) {
                    double value = instance.valueSparse(i);
                    if (Utils.isMissingValue(value)) continue;
                    int n = j;
                    vals[n] = vals[n] + this.m_rmatrix[j][index] * value;
                    continue;
                }
                vals[this.m_k] = instance.valueSparse(i);
            }
        }
        return new DenseInstance(instance.weight(), vals);
    }

    protected double rndmNum(boolean useDstrWithZero) {
        if (useDstrWithZero) {
            return sqrt3 * (double)vals[this.weightedDistribution(weights)];
        }
        return vals2[this.weightedDistribution(weights2)];
    }

    protected int weightedDistribution(int[] weights) {
        int sum = 0;
        for (int weight : weights) {
            sum += weight;
        }
        int val = (int)Math.floor(this.m_random.nextDouble() * (double)sum);
        for (int i = 0; i < weights.length; ++i) {
            if ((val -= weights[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14609 $");
    }

    public static void main(String[] argv) {
        RandomProjection.runFilter(new RandomProjection(), argv);
    }
}

