# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' ZigZagGaussian
#' 
#' Applies the Zig-Zag Sampler to a Gaussian target distribution, as detailed in Bierkens, Fearnhead, Roberts, The Zig-Zag Process and Super-Efficient Sampling for Bayesian Analysis of Big Data, 2016.
#' Assume potential of the form \deqn{U(x) = (x - mu)^T V (x - mu)/2,} i.e. a Gaussian with mean vector \code{mu} and covariance matrix \code{inv(V)}
#'
#' @param V the inverse covariance matrix (or precision matrix) of the Gaussian target distribution.
#' @param mu mean of the Gaussian target distribution
#' @param n_iter Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param finalTime If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param x0 starting point (optional, if not specified taken to be the origin)
#' @param v0 starting direction (optional, if not specified taken to be +1 in every component)
#' @return Returns a list with the following objects:
#' @return \code{Times}: Vector of switching times
#' @return \code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @examples
#' V <- matrix(c(3,1,1,3),nrow=2)
#' mu <- c(2,2)
#' result <- ZigZagGaussian(V, mu, 100)
#' plot(result$Positions[1,], result$Positions[2,],type='l',asp=1)
#' @export
ZigZagGaussian <- function(V, mu, n_iter = -1L, finalTime = -1, x0 = numeric(0), v0 = numeric(0)) {
    .Call('_RZigZag_ZigZagGaussian', PACKAGE = 'RZigZag', V, mu, n_iter, finalTime, x0, v0)
}

#' ZigZagLogistic
#'
#' Applies the Zig-Zag Sampler to logistic regression, as detailed in Bierkens, Fearnhead, Roberts, The Zig-Zag Process and Super-Efficient Sampling for Bayesian Analysis of Big Data, 2019.
#'
#' @param dataX Design matrix containing observations of the independent variables x. The i-th row represents the i-th observation with components x_{i,1}, ..., x_{i,d}.
#' @param dataY Vector of length n containing {0, 1}-valued observations of the dependent variable y.
#' @param n_iter Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param finalTime If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param x0 starting point (optional, if not specified taken to be the origin)
#' @param v0 starting direction (optional, if not specified taken to be +1 in every component)
#' @param cv optional boolean to indicate the use of subsampling with control variates
#' @return Returns a list with the following objects:
#' @return \code{Times}: Vector of switching times
#' @return \code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @examples
#' require("RZigZag")
#'
#' generate.logistic.data <- function(beta, n.obs) {
#'   dim <- length(beta)
#'   dataX <- cbind(rep(1.0,n.obs), matrix(rnorm((dim -1) * n.obs), ncol = dim -1));
#'   vals <- dataX %*% as.vector(beta)
#'     generateY <- function(p) { rbinom(1, 1, p)}
#'   dataY <- sapply(1/(1 + exp(-vals)), generateY)
#'     return(list(dataX = dataX, dataY = dataY))
#' }
#'
#' beta <- c(1,2)
#' data <- generate.logistic.data(beta, 1000)
#' result <- ZigZagLogistic(data$dataX, data$dataY, 1000)
#' plot(result$Positions[1,], result$Positions[2,],type='l',asp=1)
#' @export
ZigZagLogistic <- function(dataX, dataY, n_iter = -1L, finalTime = -1, x0 = numeric(0), v0 = numeric(0), cv = FALSE) {
    .Call('_RZigZag_ZigZagLogistic', PACKAGE = 'RZigZag', dataX, dataY, n_iter, finalTime, x0, v0, cv)
}

#' ZigZagStudentT
#' 
#' Applies the Zig-Zag Sampler to a Student T distribution (IID or spherically symmetric)
#'
#' @param dof scalar indicating degrees of freedom
#' @param dim dimension
#' @param n_iter Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param finalTime If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param x0 starting point (optional, if not specified taken to be the origin)
#' @param v0 starting direction (optional, if not specified taken to be +1 in every component)
#' @param sphericallySymmetric boolean. If false, sample iid Student T distribution, if true (default) sample spherically summetric Student t dsitribution.
#' @return Returns a list with the following objects:
#' @return \code{Times}: Vector of switching times
#' @return \code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @examples
#' dim = 2
#' dof = 4
#' result <- ZigZagStudentT(dof, dim, n_iter=1000, sphericallySymmetric = TRUE)
#' plot(result$Positions[1,], result$Positions[2,],type='l',asp=1)
#' @export
ZigZagStudentT <- function(dof, dim = 1L, n_iter = -1L, finalTime = -1, x0 = numeric(0), v0 = numeric(0), sphericallySymmetric = TRUE) {
    .Call('_RZigZag_ZigZagStudentT', PACKAGE = 'RZigZag', dof, dim, n_iter, finalTime, x0, v0, sphericallySymmetric)
}

#' BPSStudentT
#' 
#' Applies the Zig-Zag Sampler to a Student T distribution (IID or spherically symmetric)
#'
#' @param dof scalar indicating degrees of freedom
#' @param dim dimension
#' @param n_iter Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param finalTime If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param x0 starting point (optional, if not specified taken to be the origin)
#' @param v0 starting direction (optional, if not specified taken to be a random vector)
#' @param sphericallySymmetric boolean. If false, sample iid Student T distribution, if true (default) sample spherically summetric Student t dsitribution.
#' @param refresh_rate \code{lambda_refresh}
#' @param unit_velocity TRUE indicates velocities uniform on unit sphere, FALSE (default) indicates standard normal velocities
#' @return Returns a list with the following objects:
#' @return \code{Times}: Vector of switching times
#' @return \code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @examples
#' dim = 2
#' dof = 4
#' result <- BPSStudentT(dof, dim, n_iter=1000,sphericallySymmetric = TRUE)
#' plot(result$Positions[1,], result$Positions[2,],type='l',asp=1)
#' @export
BPSStudentT <- function(dof, dim = 1L, n_iter = -1L, finalTime = -1, x0 = numeric(0), v0 = numeric(0), sphericallySymmetric = TRUE, refresh_rate = 1, unit_velocity = FALSE) {
    .Call('_RZigZag_BPSStudentT', PACKAGE = 'RZigZag', dof, dim, n_iter, finalTime, x0, v0, sphericallySymmetric, refresh_rate, unit_velocity)
}

#' ZigZagIIDGaussian
#' 
#' Applies the Zig-Zag Sampler to a IID Gaussian distribution
#'
#' @param variance scalar indicating variance
#' @param dim dimension
#' @param n_iter Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param finalTime If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param x0 starting point (optional, if not specified taken to be the origin)
#' @param v0 starting direction (optional, if not specified taken to be +1 in every component)
#' @return Returns a list with the following objects:
#' @return \code{Times}: Vector of switching times
#' @return \code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @examples
#' result <- ZigZagIIDGaussian(1, 2, 1000)
#' plot(result$Positions[2,], result$Positions[1,],type='l',asp=1)
#' @export
ZigZagIIDGaussian <- function(variance, dim = 1L, n_iter = -1L, finalTime = -1, x0 = numeric(0), v0 = numeric(0)) {
    .Call('_RZigZag_ZigZagIIDGaussian', PACKAGE = 'RZigZag', variance, dim, n_iter, finalTime, x0, v0)
}

#' BPSGaussian
#'
#' Applies the BPS Sampler to a Gaussian target distribution, as detailed in Bouchard-Côté et al, 2017.
#' Assume potential of the form \deqn{U(x) = (x - mu)^T V (x - mu)/2,} i.e. a Gaussian with mean vector \code{mu} and covariance matrix \code{inv(V)}
#'
#' @param V the inverse covariance matrix (or precision matrix) of the Gaussian target distribution.
#' @param mu mean of the Gaussian target distribution
#' @param n_iter Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param x0 starting point (optional, if not specified taken to be the origin)
#' @param v0 starting direction (optional, if not specified taken to be a random vector)
#' @param finalTime If provided and nonnegative, run the BPS sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param refresh_rate \code{lambda_refresh}
#' @param unit_velocity TRUE indicates velocities uniform on unit sphere, FALSE (default) indicates standard normal velocities
#' @return Returns a list with the following objects:
#' @return \code{Times}: Vector of switching times
#' @return \code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @examples
#' V <- matrix(c(3,1,1,3),nrow=2)
#' mu <- c(2,2)
#' x0 <- c(0,0)
#' result <- BPSGaussian(V, mu, n_iter = 100, x0 = x0)
#' plot(result$Positions[1,], result$Positions[2,],type='l',asp=1)
#' @export
BPSGaussian <- function(V, mu, n_iter = -1L, finalTime = -1.0, x0 = numeric(0), v0 = numeric(0), refresh_rate = 1, unit_velocity = FALSE) {
    .Call('_RZigZag_BPSGaussian', PACKAGE = 'RZigZag', V, mu, n_iter, finalTime, x0, v0, refresh_rate, unit_velocity)
}

#' BPSIIDGaussian
#' 
#' Applies the Bouncy Particle Sampler to a IID Gaussian distribution
#'
#' @param variance scalar indicating variance
#' @param dim dimension
#' @param n_iter Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param finalTime If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param x0 starting point (optional, if not specified taken to be the origin)
#' @param v0 starting direction (optional, if not specified taken to be a random vector)
#' @param refresh_rate \code{lambda_refresh}
#' @param unit_velocity TRUE indicates velocities uniform on unit sphere, FALSE (default) indicates standard normal velocities
#' @return Returns a list with the following objects:
#' @return \code{Times}: Vector of switching times
#' @return \code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @examples
#' result <- BPSIIDGaussian(1, 2, 1000)
#' plot(result$Positions[2,], result$Positions[1,],type='l',asp=1)
#' @export
BPSIIDGaussian <- function(variance, dim = 1L, n_iter = -1L, finalTime = -1, x0 = numeric(0), v0 = numeric(0), refresh_rate = 1, unit_velocity = FALSE) {
    .Call('_RZigZag_BPSIIDGaussian', PACKAGE = 'RZigZag', variance, dim, n_iter, finalTime, x0, v0, refresh_rate, unit_velocity)
}

#' EstimateESS
#' 
#' Estimates the effective sample size (ESS) of a piecewise deterministic skeleton
#' 
#' @param skeletonList a piecewise deterministic skeleton (consisting of Times, Points and Velocities) returned by a sampler
#' @param n_batches optional argument indicating the number of batches to use in the batch means estimation method
#' @param coordinate if specified, only estimate the ESS of the specified coordinate, otherwise estimate the ESS of all coordinates
#' @param zeroMeans if TRUE do not estimate means but assume a centered distribution
#' @return Returns a list containing the estimated asymptotic variance, ESS and estimated covariance matrix
#' @export
EstimateESS <- function(skeletonList, n_batches = 100L, coordinate = -1L, zeroMeans = FALSE) {
    .Call('_RZigZag_EstimateESS', PACKAGE = 'RZigZag', skeletonList, n_batches, coordinate, zeroMeans)
}

#' EstimateMoment
#' 
#' Estimates the p-th moment of a piecewise deterministic skeleton
#' 
#' @param skeletonList a piecewise deterministic skeleton (consisting of Times, Points and Velocities) returned by a sampler
#' @param p moment to estimate
#' @param coordinate if specified, only estimate the ESS of the specified coordinate, otherwise estimate the ESS of all coordinates
#' @return Returns a list containing the estimated moment
#' @export
EstimateMoment <- function(skeletonList, p, coordinate = -1L) {
    .Call('_RZigZag_EstimateMoment', PACKAGE = 'RZigZag', skeletonList, p, coordinate)
}

#' EstimateCovarianceMatrix
#' 
#' Estimates the covariance matrix of a piecewise deterministic skeleton
#' 
#' @param skeletonList a piecewise deterministic skeleton (consisting of Times, Points and Velocities) returned by a sampler
#' @param coordinate if specified, only estimate the variance of the specified coordinate, otherwise estimate the covariance matrix of all coordinates
#' @param zeroMeans if TRUE do not estimate means but assume a centered distribution
#' @return Returns a list containing the estimated moment
#' @export
EstimateCovarianceMatrix <- function(skeletonList, coordinate = -1L, zeroMeans = FALSE) {
    .Call('_RZigZag_EstimateCovarianceMatrix', PACKAGE = 'RZigZag', skeletonList, coordinate, zeroMeans)
}

#' DiscreteSamples
#' 
#' Extract discrete samples from a skeleton
#' 
#' @param skeletonList a piecewise deterministic skeleton (consisting of Times, Points and Velocities) returned by a sampler
#' @param n_samples number of samples to obtain
#' @param coordinate if specified, only obtain samples of the specified coordinate, otherwise obtain samples of all coordinates
#' @return Returns a list containing the extracted samples and the times (on the continuous time scale) at which the samples are extracted
#' @export
DiscreteSamples <- function(skeletonList, n_samples, coordinate = -1L) {
    .Call('_RZigZag_DiscreteSamples', PACKAGE = 'RZigZag', skeletonList, n_samples, coordinate)
}

