library(testthat)
library(RZooRoH)

#test_check("RZooRoH")
context("Reading")

test_that("Reading genoex",{
  myfile1 <- system.file("exdata","genoex.txt",package="RZooRoH")
  data1 <- zoodata(myfile1)
  expect_equal(data1@nsnps,14831)
  expect_equal(data1@nind,20)
  data1 <- zoodata(myfile1,min_maf = 0.02)
  expect_equal(data1@nsnps,11371)
  expect_equal(data1@zformat,"gt")
  expect_equal(round(data1@freqs[1],2),0.39)
})

test_that("Reading genosim",{
  myfile1 <- system.file("exdata","genosim.txt",package="RZooRoH")
  data1 <- zoodata(myfile1, chrcol = 1, poscol =2, supcol = 4, min_maf = 0.01)
  expect_equal(data1@nsnps,9598)
  expect_equal(data1@nind,20)
  expect_equal(data1@zformat,"gt")
  expect_equal(round(data1@freqs[20],2),0.52)
})

test_that("Reading various formats",{
  file1 <- system.file("exdata","BBB_PE_gt_subset.txt",package="RZooRoH")
  file2 <- system.file("exdata","BBB_NMP_pl_subset.txt",package="RZooRoH")
  file3 <- system.file("exdata","BBB_NMP_GP_subset.txt",package="RZooRoH")
  file4 <- system.file("exdata","BBB_NMP_ad_subset.txt",package="RZooRoH")
  BBB_GP <- zoodata(genofile = file3, zformat = "gp")
  expect_equal(BBB_GP@nind,10)
  expect_equal(BBB_GP@nsnps,1000)
  expect_equal(round(BBB_GP@freqs[1],2),0.87)
  BBB_AD <- zoodata(file4, zformat = "ad")
  expect_equal(BBB_AD@nind,10)
  expect_equal(BBB_AD@nsnps,1000)
  expect_equal(round(BBB_AD@freqs[1],2),0.95)
  BBB_GT <- zoodata(file1, supcol = 4, poscol = 2, chrcol = 1)
  expect_equal(BBB_GT@nind,10)
  expect_equal(BBB_GT@nsnps,1000)
  expect_equal(round(BBB_GT@freqs[1],2),0)
  BBB_PL <- zoodata(genofile = file2, zformat = "gl")
  expect_equal(BBB_PL@nind,10)
  expect_equal(BBB_PL@nsnps,1000)
  expect_equal(round(BBB_PL@freqs[1],2),0.80)
})
