% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{varRegression}
\alias{varRegression}
\title{Linear Regression of Sources of Variability}
\usage{
varRegression(object, vars = NULL, logscale = FALSE, Batch = FALSE)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{vars}{data.frame of variables to be regressed out. Each column corresponds to a variable and each variable corresponds to a cell.
The object must contain all cells, i.e. column names of the slot \code{ndata} from the \code{SCseq} object.}

\item{logscale}{logical. If \code{TRUE} data are log-transformed prior to regression. Default is \code{FALSE}.}

\item{Batch}{logical. If \code{TRUE}, then the function will regress out batch-associated variability based on genes stored in the \code{filterpar$BGenes}
slot of the \code{SCseq} object. This requires prior batch correction with the \code{filterdata} function using \code{bmode="RaceID"}.}
}
\value{
The function returns an updated \code{SCseq} object with the corrected expression matrix written to the slot \code{dimRed$x} of the \code{SCseq} object.
}
\description{
This functions regresses out variability associated with particular sources.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
b <- sub("(\\\\_\\\\d+)$","",colnames(intestinalData))
vars <- data.frame(row.names=colnames(intestinalData),batch=b)
sc   <- varRegression(sc,vars)
}
