% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{clustexp}
\alias{clustexp}
\title{Clustering of single-cell transcriptome data}
\usage{
clustexp(
  object,
  sat = TRUE,
  samp = NULL,
  cln = NULL,
  clustnr = 30,
  bootnr = 50,
  rseed = 17000,
  FUNcluster = "kmedoids",
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{sat}{logical. If \code{TRUE}, then the number of clusters is determined based on finding the saturation point of the mean within-cluster
dispersion as a function of the cluster number. Default is \code{TRUE}. If \code{FALSE}, then cluster number needs to be given as \code{cln}.}

\item{samp}{Number of random sample of cells used for the inference of cluster number and for inferring Jaccard similarities.
Default is 1000.}

\item{cln}{Number of clusters to be used. Default is \code{NULL} and the cluster number is inferred by the saturation criterion.}

\item{clustnr}{Maximum number of clusters for the derivation of the cluster number by the saturation of mean within-cluster-dispersion.
Default is 30.}

\item{bootnr}{Number of booststrapping runs for \code{clusterboot}. Default is 50.}

\item{rseed}{Integer number. Random seed to enforce reproducible clustering results. Default is 17000.}

\item{FUNcluster}{Clustering method used by RaceID3. One of \code{"kmedoids", "kmeans", "hclust"}. Default is \code{"kmedoids"}.}

\item{verbose}{logical. If \code{FALSE} then status output messages are disabled. Default is \code{TRUE}.}
}
\value{
\code{SCseq} object with clustering data stored in slot \code{cluster} and slot \code{clusterpar}. The clustering partition is stored in
\code{cluster$kpart}.
}
\description{
This functions performs the initial clustering of the RaceID3 algorithm.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
}
