% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StemID.R
\name{branchcells}
\alias{branchcells}
\title{Differential Gene Expression between Links}
\usage{
branchcells(object, br)
}
\arguments{
\item{object}{\code{Ltree} class object.}

\item{br}{List containing two branches, where each component has to be two valid cluster numbers seperated by a \code{.} and with one common cluster in the two components. The lower number precedes the larger one, i.e. \code{1.3}.
For each component, the cluster number need to be ordered in increasing order.}
}
\value{
A list ot four components:
  \item{n}{a vector with the number of significant links for each cluster.}
  \item{scl}{a vector with the delta entropy for each cluster.}
  \item{k}{a vector with the StemID score for each cluster.}
  \item{diffgenes}{a vector with the StemID score for each cluster.}
}
\description{
This function computes expression z-score between groups of cells from the same cluster residing on different links
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
sc <- comptsne(sc)
ltr <- Ltree(sc)
ltr <- compentropy(ltr)
ltr <- projcells(ltr)
ltr <- lineagegraph(ltr)
ltr <- comppvalue(ltr)
x <- branchcells(ltr,list("1.3","3.6"))
head(x$diffgenes$z)
plotmap(x$scl)
plotdiffgenes(x$diffgenes,names(x$diffgenes$z)[1])

}
