\name{subset.DVH.list}
\docType{methods}
\alias{subset-methods}
\alias{subset.DVH.list}
\alias{subset,DVH-method}
\alias{subset,DVH.list-method}
\title{
Extract a subset of a larger DVH list
}
\description{
This function is designed to isolate one or more structure(s) from a list of DVH lists according to user input.
}
\usage{
\method{subset}{DVH.list}(x, structure, patient, ID, constraint, ignore.case=TRUE, select)
}
\arguments{
  \item{x}{
	Represents a \code{DVH.list} object (e.g. generated by \code{read.DVH()}).
}
  \item{structure}{
		Vector used to sub-select structures from \code{x}; may be a character vector containing structure names (regular expressions may be specified if desired, see \code{\link{regex}} for more details).
	}
  \item{patient}{
		Vector used to sub-select specific patient data from \code{x}; may be a character vector containing patient names (regular expressions may be specified if desired, see \code{\link{regex}} for more details).
	}
  \item{ID}{
		Vector used to sub-select specific patient data from \code{x} using exact matching on patient identifiers.
	}
  \item{constraint}{
  	Vector of one or more dosimetric constraints to apply to \code{x} to assess whether or not each component DVH should be included in the resultant list.  More than one parameter may be specified at a time. Parameter specification should be of the form \code{"<A><B><C> <?> <D>(<E>)"}: \code{<A>} is equivalent to \code{"V"} or \code{"D"}, representing a volume or dose, respectively; \code{<B>} usually denotes a numerical value specifying the dose or volume; \code{<C>} represents the dose or volume units (\code{"cGy"}, \code{"Gy"}, \code{"\%"}, or \code{"cc"}); \code{<?>} represents a logical comparator (e.g. \code{">="} or \code{"<"} or \code{"!="}); \code{<D>} represents a comparative value; and \code{<E>} represents the units of comparison (e.g. \code{"\%"} or \code{"Gy"}). An example would be \code{"V20Gy < 50(\%)"} which represents a test of whether or not the volume of the structure receiving at least 20Gy dose is less than 50\% of the overall structure volume. Dose ranges may also be specified, for instance \code{"V10-20Gy"} or \code{"V<20Gy"}. Specialized dosimetric keywords may also be used:  \code{"Dmax"} (maximum dose), \code{"Dmin"} (minimum dose), \code{"Dmean"} (mean dose), \code{"Dmedian"} (median dose), \code{"Dintegral"} (estimated integral dose), \code{"DRx"} (prescription dose), and \code{"volume"} (total structure volume).  If an improper parameter is specified however, \code{NA} results will be returned. See package documentation (vignette) for more details. 
	}
  \item{ignore.case}{
		Logical value specifying whether or not to use case-sensitive pattern matching; if \code{TRUE} (default), case is ignored during matching, and if \code{FALSE}, the pattern matching is \emph{case sensitive}.
	}
  \item{select}{
		Must be one of \code{"all"} (default), \code{"any"}, or \code{"none"}. This value specifies the how to combine multiple selection inputs.  When \code{select = "all"}, a given DVH is only included in the resulting DVH list when it matches with all specififed inputs (for instance, must be a specific structure from a specific patient).  When \code{select = "any"}, a DVH may be included in the result DVH list if it matches any specified inputs.  When \code{select = "none"}, a DVH will only be included int eh resulting DVH list if it does not match with any of the specified criteria.  For more details, see examples, below.
	}

}
\value{
Returns a single DVH list
}
\author{
Reid F. Thompson (\email{reid.thompson@gmail.com})
}
\seealso{
\code{\link[RadOnc:DVH.list-class]{DVH.list}}
}
\examples{
data(list="RadOnc", package="RadOnc")
subset(johndoe, structure="kidney", constraint="Dmean < 500(cGy)", ignore.case=TRUE)
subset(johndoe, constraint="volume > 200(cc)")}
\keyword{ methods }
\keyword{ manip }
