% Generated by roxygen2 (4.0.1): do not edit by hand
\name{probability}
\alias{probability}
\title{Probability computation}
\usage{
probability(x, mu, pi, m = length(x))
}
\arguments{
\item{x}{a vector or a matrix of 1 row containing the rankings in ranking notation (see Details or \link{convertRank} function). The rankings of each dimension are
placed end to end. x must contain only full ranking (no partial or tied).}

\item{pi}{a vector of size p, where p is the number of dimension, containing the probabilities of a good comparaison of the model (dispersion parameters).}

\item{mu}{a vector of length sum(m) or a matrix of size 1*sum(m), containing the modal ranks in ranking notation (see Details or \link{convertRank} function). The rankings of each dimension are
placed end to end. mu must contain only full ranking (no partial or tied).}

\item{m}{a vector containing the size of ranks for each dimension.}
}
\value{
the probability of x according to a multivariate ISR o parameter mu and pi.
}
\description{
This function computes the probability of x according to a multivariate ISR o parameter mu and pi.
}
\details{
The ranks have to be given to the package in the ranking notation (see \link{convertRank} function), with the following convention :

- missing positions are replaced by 0

- tied are replaced by the lowest position they share"


  The ranking representation r=(r_1,...,r_m) contains the
ranks assigned to the objects, and means that the ith
object is in r_ith position.

The ordering representation o=(o_1,...,o_m) means that object
o_i is in the ith position.

Let us consider the following example to illustrate both
notations: a judge, which has to rank three holidays
destinations according to its preferences, O1 =
  Countryside, O2 =Mountain and O3 = Sea, ranks first Sea,
second Countryside, and last Mountain. The ordering
result of the judge is o = (3, 1, 2) whereas the ranking
result is r = (2, 3, 1).
}
\examples{
m=c(4,5)
x=mu=matrix(nrow=1,ncol=9)
x[1:4] = c(1,4,2,3)
x[5:9] = c(3,5,2,4,1)
mu[1:4] = 1:4
mu[5:9] = c(3,5,4,2,1)
pi=c(0.75,0.82)

prob=probability(x,mu,pi,m)
prob
}
\author{
Quentin Grimonprez
}

