% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvh_cleanHRUs.R
\name{rvn_rvh_cleanhrus}
\alias{rvn_rvh_cleanhrus}
\title{Clean HRU data table.}
\usage{
rvn_rvh_cleanhrus(
  HRUtab,
  SBtab,
  area_tol = 0.01,
  merge = FALSE,
  elev_tol = 50,
  slope_tol = 4,
  aspect_tol = 20,
  ProtectedHRUList = c()
)
}
\arguments{
\item{HRUtab}{table of HRUs generated (typically) by \code{\link{rvn_rvh_read}}}

\item{SBtab}{table of Subbasins generated (typically) by \code{\link{rvn_rvh_read}}}

\item{area_tol}{percentage of watershed area beneath which HRUs should be removed (e.g.,
default value of 0.01 would indicate anything smaller than 1 percent of watershed extent should be removed)}

\item{merge}{TRUE if similar HRUs are to be merged (this can be slow for large models)}

\item{elev_tol}{elevation difference (in metres) considered similar. only used if merge=TRUE.}

\item{slope_tol}{slope difference (in degrees) considered similar. only used if merge=TRUE.}

\item{aspect_tol}{slope difference (in degrees) considered similar. only used if merge=TRUE.}

\item{ProtectedHRUList}{list of HRU IDs that are sacrosanct (not to be removed)}
}
\value{
{hru_table}{cleaned HRU table as a dataframe}
}
\description{
Takes \code{\link{rvn_rvh_read}}-generated HRUtable and SBTable and returns cleaned HRUtable
with (hopefully) fewer HRUs
}
\details{
rvh.clean removes HRUs in two ways:

  1. it removes all HRUs smaller than the area_tol percentage of total area. Adjacent HRUs in the
subbasin are expanded by the lost area to keep the same relative coverage.

  2. it consolidates similar HRUs within the same subbasin (those with same land cover,
    vegetation, soil profile and similar slope, aspect, and elevation)
}
\examples{
# read in example rvh file
nith <- system.file("extdata","Nith.rvh",package = "RavenR")
rvh <- rvn_rvh_read(nith)

# number of HRUs in existing configuration
nrow(rvh$HRUtable)

# clean contents (in this case, remove all HRUs covering less than 5\% of the total area)
rvh$HRUtable <- rvn_rvh_cleanhrus(rvh$HRUtable,rvh$SBtable,area_tol = 0.05, merge=TRUE)

}
\seealso{
\code{\link{rvn_rvh_read}} for the function used to read in the HRU and Subbasin data, and
\code{\link{rvn_rvh_write}} to write rvh information to file.
}
\author{
James R. Craig, University of Waterloo
}
