% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_xts_plot.R
\name{rvn_xts_plot}
\alias{rvn_xts_plot}
\title{Create plot from xts data}
\usage{
rvn_xts_plot(
  x = NULL,
  prd = NULL,
  winter_shading = FALSE,
  wsdates = c(12, 1, 3, 31)
)
}
\arguments{
\item{x}{time series object (xts) of data to plot}

\item{prd}{period to use in plotting}

\item{winter_shading}{optionally adds shading for winter months (default FALSE)}

\item{wsdates}{integer vector of winter shading period dates (see details)}
}
\value{
\item{p1}{returns ggplot plot object}
}
\description{
rvn_xts_plot is a generic function for plotting data from an xts format
using the ggplot2 function.
}
\details{
This function creates a plot using the supplied time series in
xts format. The xts object is converted to a tibble using the \code{\link{rvn_fortify_xts}}
function, and all columns are plotted by their respective names.

The winter_shading argument will add a transparent grey shading for the
specified period by wsdates in each year that is plotted. Note that by changing the
wsdates parameter values, the shading can be applied to any time of year.

wsdates is formatted as c(winter start month, winter start day, winter end month, winter end day).
By default, wsdates is set to generate shading for December 1st to March 31st.

Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{

# load sample hydrograph data, two years worth of sim/obs
ff <- system.file("extdata","run1_Hydrographs.csv", package="RavenR")
run1 <- rvn_hyd_read(ff)

# create a hydrograph with the generic xts plotting function
rvn_xts_plot(run1$hyd)

# add shading for the month of August
rvn_xts_plot(run1$hyd, winter_shading=TRUE, wsdates=c(8,1,8,31))

}
\seealso{
\code{\link{rvn_hyd_plot}} to create a hydrograph plot

\code{\link{rvn_hyd_extract}} to extract time series from Raven objects
}
