% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticdiff.R
\name{staticdiff}
\alias{staticdiff}
\title{Static frame difference background subtraction algorithm.}
\usage{
staticdiff(b, thresh)
}
\arguments{
\item{b}{3-D matrix containing grayscaled video frames.}

\item{thresh}{threshold required to obtain foreground images. Its value can lie between 30-40
or more depending upon the accuracy required.}
}
\value{
A 3-D matrix of frames containing foreground obtained after background subtraction is
applied(binary images).
}
\description{
This function implements a static background subtraction method in which background model is
set to first frame. This static background model is then subtracted from all subsequent frames
to obtain the forground images.
}
\examples{
 \donttest{
videoURL <- system.file("extdata","daria_skip.avi",package = "Rbgs")
frames <- readvideoframe(videoURL,1,9)
bground<-staticdiff(frames,35) }
}
