% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleView.R
\name{abdPlotTabs}
\alias{abdPlotTabs}
\title{Abundances barplots inside Tk tabs.}
\usage{
abdPlotTabs(clusterings, nb, RclusTool.env = initParameters())
}
\arguments{
\item{clusterings}{clustering list.}

\item{nb}{a notebook.}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}
}
\description{
Display the abundances barplot of a clustering.
}
\details{
abdPlotTabs displays the abundances barplot of a set of clusterings in Tk tabs of a notebook.
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 6, sd = 0.3), ncol = 2))
colnames(dat) <- c("x","y")
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

mainWindow <- tktoplevel()
tktitle(mainWindow) <- "Barplot clustering"  
mainWindow$env$nb <- tk2notebook(mainWindow, tabs = c())
tkpack(mainWindow$env$nb, fill="both", expand= TRUE)

x <- importSample(file.features=tf, dir.save=tempdir())
method <- "K-means"

x <- computeUnSupervised(x, K=3, method.name=method)

abdPlotTabs(x$clustering, mainWindow$env$nb)
 

}
\keyword{internal}
