% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{clusterSummary}
\alias{clusterSummary}
\title{Clusters summaries computation}
\usage{
clusterSummary(data.sample, label,
  features.to.keep = colnames(data.sample$features[["preprocessed"]]$x),
  summary.functions = c(Min = "min", Max = "max", Sum = "sum", Average =
  "mean", SD = "sd"))
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{label}{vector of labels.}

\item{features.to.keep}{vector of features names on which the summaries are computed.}

\item{summary.functions}{vector of functions names for the summaries computation. Could be 'Min', 'Max', 'Sum', 'Average', 'sd'.}
}
\value{
out data.frame containing the clusters summaries.
}
\description{
Save clusters summaries results in a csv file.
}
\details{
clusterSummary computes the clusters summaries (min, max, sum, average, sd) from a clustering result.
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1, dir.save=tempdir())
res <- KmeansQuick(x$features$initial$x, K=3)
labels <- formatLabelSample(res$cluster, x)
cluster.summary <- clusterSummary(x, labels)


}
