\name{interfacesAttribute}
\alias{interfacesAttribute}

\title{Rcpp::interfaces Attribute}

\description{
The \code{Rcpp::interfaces} attribute is added to a C++ source file to specify which languages to generate bindings for from exported functions. For example:
\preformatted{
// [[Rcpp::interfaces(r, cpp)]]
}
}

\arguments{
 \item{\dots}{
    Interfaces to generate for exported functions within the source file. Valid values are \code{r} and \code{cpp}, and more than one interface can be specified.
}
}

\details{
    The \code{Rcpp::interfaces} attribute is used to determine which bindings to generate for exported functions. The default behavior if no \code{Rcpp::interfaces} attribute is specified is to generate only an R interface. 
    
    When \code{cpp} bindings are requested code is generated as follows:

\enumerate{
    \item Bindings are generated into a header file located in the \code{inst/include} directory of the package using the naming convention \emph{PackageName_RcppExports.h}
    \item If not already present, an additional header file named \emph{PackageName.h} is also generated which in turn includes the Rcpp exports header. 
    
    In the case that you already have a \emph{PackageName.h} header for your package then you can manually add an include of the Rcpp exports header to it to make the exported functions available to users of your package.
    \item The generated header file allows calling the exported C++ functions without any linking dependency on the package (this is based on using the \code{R_RegisterCCallable} and \code{R_GetCCallable} functions).
    \item The exported functions are defined within a C++ namespace that matches the name of the package.
}
For example, an exported C++ function \code{foo} could be called from package \code{MyPackage} as follows:

\preformatted{
   // [[Rcpp::depends(MyPackage)]]

   #include <MyPackage.h>

   void foo() {
      MyPackage::bar();
   }
}

    The above example assumes that the \code{sourceCpp} function will be used to compile the code. If rather than that you are building a package then you don't need to include the \code{Rcpp::depends} attribute, but instead should add an entry for the referenced package in the \code{Depends} and \code{LinkingTo} fields of your package's \code{DESCRIPTION} file. 

}

\note{

    If a file by the name of \emph{PackageName.h} that wasn't generated by \code{compileAttributes} already exists in in the \code{inst/include} directory then it will not be overwritten (rather, an error will occur).
    
    A static naming scheme for generated header files and namespaces is used to ensure consistent usage semantics for clients of exported \code{cpp} interfaces. Packages that wish to export more complex interfaces or additional C++ types are therefore typically better off not using this mechanism.

    The \code{Rcpp::interfaces} attribute is specified using a syntax compatible with the new \href{http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2008/n2761.pdf}{generalized attributes} feature of the C++11 standard. Note however that since this feature is not yet broadly supported by compilers it needs to be specified within a comment (see examples below).
}


\seealso{
\code{\link{compileAttributes}}, \code{\link[=exportAttribute]{Rcpp::export}}, \code{\link[=dependsAttribute]{Rcpp::depends}}
}

\examples{
\dontrun{

// [[Rcpp::interfaces(r, cpp)]]
}
}

