% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{s_attribute_decode}
\alias{s_attribute_decode}
\title{Decode Structural Attribute.}
\usage{
s_attribute_decode(corpus, data_dir, s_attribute, encoding = NULL,
  registry = Sys.getenv("CORPUS_REGISTRY"), method = c("R", "Rcpp"))
}
\arguments{
\item{corpus}{a CWB corpus}

\item{data_dir}{data directory where binary files for corpus are stored}

\item{s_attribute}{a structural attribute}

\item{encoding}{encoding of the values ("latin-1" or "utf-8")}

\item{registry}{registry directory}

\item{method}{character vector, whether to use "R" or "Rcpp" implementation}
}
\value{
A \code{data.frame} with three columns. Column \code{cpos_left} are the start
corpus positions of a structural annotation, \code{cpos_right} the end corpus positions.
Column \code{value} is the value of the annotation.

a character vector
}
\description{
Get \code{data.frame} with left and right corpus positions (cpos) for structural
attributes and values.
}
\details{
Two approaches are implemented: A pure R solution will decode the files directly in 
the directory specified by \code{data_dir}. An implementation using Rcpp will use the
registry file for \code{corpus} to find the data directory.
}
\examples{
registry <- if (!check_pkg_registry_files()) use_tmp_registry() else get_pkg_registry()
Sys.setenv(CORPUS_REGISTRY = registry)

# pure R implementation (Rcpp implementation fails on Windows in vanilla mode)
b <- s_attribute_decode(
  data_dir = system.file(package = "RcppCWB", "extdata", "cwb", "indexed_corpora", "reuters"),
  s_attribute = "places", method = "R"
  )
}
