% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.R
\name{cl_rework}
\alias{cl_rework}
\alias{s_attr}
\alias{p_attr}
\alias{p_attr_size}
\alias{s_attr_size}
\alias{p_attr_lexicon_size}
\alias{cpos_to_struc}
\alias{cpos_to_str}
\alias{cpos_to_id}
\alias{struc_to_cpos}
\alias{struc_to_str}
\alias{regex_to_id}
\alias{str_to_id}
\alias{id_to_freq}
\alias{id_to_cpos}
\alias{cpos_to_lbound}
\alias{cpos_to_rbound}
\title{Experimental low-level CL access.}
\usage{
s_attr(corpus, s_attribute, registry = Sys.getenv("CORPUS_REGISTRY"))

p_attr(corpus, p_attribute, registry = Sys.getenv("CORPUS_REGISTRY"))

p_attr_size(p_attr)

s_attr_size(s_attr)

p_attr_lexicon_size(p_attr)

cpos_to_struc(cpos, s_attr)

cpos_to_str(cpos, p_attr)

cpos_to_id(cpos, p_attr)

struc_to_cpos(struc, s_attr)

struc_to_str(struc, s_attr)

regex_to_id(regex, p_attr)

str_to_id(str, p_attr)

id_to_freq(id, p_attr)

id_to_cpos(id, p_attr)

cpos_to_lbound(cpos, s_attr)

cpos_to_rbound(cpos, s_attr)
}
\arguments{
\item{corpus}{ID of a CWB corpus (length-one \code{character} vector).}

\item{s_attribute}{A structural attribute (length-one \code{character} vector).}

\item{registry}{Registry directory.}

\item{p_attribute}{A positional attribute (length-one \code{character} vector).}

\item{p_attr}{A \code{externalptr} referencing a p-attribute.}

\item{s_attr}{A \code{externalptr} referencing a p-attribute.}

\item{cpos}{An \code{integer} vector of corpus positions.}

\item{struc}{A length-one \code{integer} vector with a struc.}

\item{regex}{A regular expression.}

\item{str}{A \code{character} vector.}

\item{id}{An \code{integer} vector with token ids.}
}
\description{
Set of functions with same functionality as cl_* functions to improve the
ease of writing code.
}
