% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{region_matrix_to_struc_matrix}
\alias{region_matrix_to_struc_matrix}
\alias{region_to_strucs}
\title{Get min and max strucs of s-attribute present in region}
\usage{
region_matrix_to_struc_matrix(
  corpus,
  s_attribute,
  region_matrix,
  registry = NULL
)

region_to_strucs(corpus, s_attribute, region, registry = NULL)
}
\arguments{
\item{corpus}{ID of a CWB corpus.}

\item{s_attribute}{Name of structural attribute. The attribute may be
nested.}

\item{region_matrix}{A two-column \code{matrix} with regions, left corpus
positions in column 1, right corpus positions in column 2.}

\item{registry}{Path of the registry directory. If \code{NULL} (default), value
of environment variable 'CORPUS_REGISTRY' will be used.}

\item{region}{Vector with left and right corpus position of region.}
}
\value{
Depending whether input is a vector (argument \code{region}) or a matrix
(argument \code{region_matrix}), a vector or a matrix.
}
\description{
Look up the minimum and maximum struc of a s-attribute within a region,
including scenario of nested s-attributes. If there are no regions of the
s-attribute within the region, \code{NA} values are returned.
}
