% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Voigt.R
\name{Voigt}
\alias{Gauss}
\alias{Lorentz}
\alias{Voigt}
\title{The Voigt function, corresponding to the convolution of a lorentzian and a gaussian distribution}
\usage{
Voigt(x, x0, sigma, gamma, real = TRUE, ...)

Lorentz(x, x0, gamma)

Gauss(x, x0, sigma)
}
\arguments{
\item{x}{numeric vector}

\item{x0}{scalar, peak position}

\item{sigma}{parameter of the gaussian}

\item{gamma}{parameter of the lorentzian}

\item{real}{logical, return only the real part of the complex Faddeeva}

\item{...}{passed to Faddeeva_w}
}
\value{
numeric or complex vector
}
\description{
Voigt distribution

Lorentzian distribution

Gaussian distribution
}
\section{Functions}{
\itemize{
\item \code{Voigt}: Voigt lineshape function

\item \code{Lorentz}: Lorentzian lineshape function

\item \code{Gauss}: Gaussian lineshape function
}}
\examples{
## should integrate to 1 in all cases
integrate(Lorentz, -Inf, Inf, x0=200, gamma=100)
integrate(Gauss, -Inf, Inf, x0=200, sigma=50)
integrate(Voigt, -Inf, Inf, x0=200, sigma=50, gamma=100)

## visual comparison
x <- seq(-1000, 1000)
x0 <- 200
l <- Lorentz(x, x0, 30)
g <- Gauss(x, x0, 100)
N <- length(x)
c <- convolve(Gauss(x, 0, 100),
              rev(Lorentz(x, x0, 30)), type="o")[seq(N/2, length=N)]
v <- Voigt(x, x0, 100, 30)
matplot(x, cbind(v, l, g, c), t="l", lty=c(1,2,2,1), xlab="x", ylab="")
legend("topleft", legend = c("Voigt", "Lorentz", "Gauss", "Convolution"), bty="n",
       lty=c(1,2,2,1), col=1:4)
}
\author{
baptiste Auguie
}

