/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.curvefitting.algorithm;

import gov.nih.ncats.ifx.qhts.curvefitting.algorithm.AlgotithmUtils;
import gov.nih.ncats.ifx.qhts.utils.HillConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Masking {
    public static boolean[] mask(double[] xs, double[] ys) {
        double sd = HillConstants.CLASSIFICATION_SD;
        double sdf = HillConstants.CLASSIFICATION_SD_FACTOR;
        return Masking.maskDif(xs, ys, null, null, null, 1, sd, sdf);
    }

    public static boolean[] maskDif(double[] xs, double[] ys, int[][] ds, double[] ms, HashMap[] maps, int dn, double sd, double sdf) {
        boolean bellFlag;
        int i;
        if (dn > 1) {
            boolean[] flags = new boolean[xs.length];
            int delta = xs.length / dn;
            for (int i2 = 0; i2 < dn; ++i2) {
                double[] xx = new double[delta];
                double[] yy = new double[delta];
                for (int j = 0; j < delta; ++j) {
                    xx[j] = xs[j * dn + i2];
                    yy[j] = ys[j * dn + i2];
                }
                boolean[] fs = Masking.maskDif(xx, yy, null, null, null, 1, sd, sdf);
                for (int j = 0; j < delta; ++j) {
                    flags[j * dn + i2] = fs[j];
                }
            }
            return flags;
        }
        boolean[] flags = new boolean[xs.length];
        for (int i3 = 0; i3 < xs.length; ++i3) {
            flags[i3] = true;
        }
        if (xs.length < 3 || !HillConstants.MASK_FLAG) {
            return flags;
        }
        int pos = -1;
        int no = 0;
        for (int i4 = 0; i4 < ys.length; ++i4) {
            if (!(Math.abs(ys[i4]) >= sd * sdf)) continue;
            ++no;
            pos = i4;
        }
        if (!HillConstants.BELL_MASK && no == 1 && pos < ys.length / 2) {
            flags[pos] = false;
            return flags;
        }
        no = 0;
        double mean = 0.0;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (int i5 = 0; i5 < xs.length; ++i5) {
            maxY = Math.max(maxY, ys[i5]);
            minY = Math.min(minY, ys[i5]);
            mean += ys[i5];
            ++no;
        }
        mean /= (double)no;
        double range = maxY - minY;
        if (range < 100.0) {
            range = 100.0;
        }
        double dev = 0.0;
        for (int i6 = 0; i6 < xs.length; ++i6) {
            double delta = ys[i6] - mean;
            dev += delta * delta;
        }
        dev = Math.sqrt(dev / (double)no);
        no = xs.length - 1;
        if (Math.abs(ys[0]) > HillConstants.P0 && Math.abs(ys[0]) - Math.abs(ys[1]) > 2.0 * sd) {
            flags[0] = false;
            if (maps != null) {
                maps[0] = AlgotithmUtils.maskInfoMap(xs[0], ys[0], ys[0], "abs(y0) > abs(y1):" + String.valueOf(ys[0]) + " " + String.valueOf(ys[1]));
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean prevVFlag = false;
        for (i = 1; i < xs.length; ++i) {
            double ratio = Math.abs(ys[i] - mean) / dev;
            if (HillConstants.TR > 0.0 && ratio > HillConstants.TR) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps == null) continue;
                maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], ratio, "(resp-mean)/std > Pref.TR:" + String.valueOf(ratio) + " " + String.valueOf(HillConstants.TR));
                continue;
            }
            boolean vFlag = false;
            if (i < no && (ys[i] - ys[i - 1]) * (ys[i] - ys[i + 1]) > 0.0 && Math.abs(ys[i] - ys[i - 1]) > HillConstants.V_DEPTH && Math.abs(ys[i] - ys[i + 1]) > HillConstants.V_DEPTH) {
                vFlag = true;
            }
            double t1 = 0.0;
            if (i > 1) {
                t1 = AlgotithmUtils.calcTheta(xs, ys, i - 2, i - 1, i);
            }
            double t2 = 0.0;
            if (i < no) {
                t2 = AlgotithmUtils.calcTheta(xs, ys, i - 1, i, i + 1);
            }
            double t = 0.0;
            t = !vFlag ? Math.max(t1, t2) : Math.min(t1, t2);
            double delta0 = Math.abs(ys[i] - ys[i - 1]);
            double delta1 = Double.MAX_VALUE;
            double delta2 = Double.MAX_VALUE;
            if (i == no) {
                delta1 = Math.abs(ys[no] - (xs[no] - xs[no - 2]) * (ys[no - 1] - ys[no - 2]) / (xs[no - 1] - xs[no - 2]) - ys[no - 2]);
            } else {
                delta1 = Math.abs(ys[i] - (xs[i] - xs[i - 1]) * (ys[i + 1] - ys[i - 1]) / (xs[i + 1] - xs[i - 1]) - ys[i - 1]);
                delta2 = Math.abs(ys[i] - ys[i + 1]);
            }
            double delta = Double.MAX_VALUE;
            delta = Math.min(delta0, delta1);
            delta = Math.min(delta2, delta);
            if (prevVFlag && i == no) {
                if (!(delta * 100.0 / range > HillConstants.TPN) || !(HillConstants.TPN > 0.0)) continue;
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps == null) continue;
                maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], delta, "Last point's delta distance > Pref.TPN:" + String.valueOf(delta) + " " + String.valueOf(HillConstants.TPN));
                continue;
            }
            if (i != no && delta * 100.0 / range > HillConstants.TP && HillConstants.TP > 0.0) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps == null) continue;
                maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], delta, "Current point's delta distance > Pref.TP:" + String.valueOf(delta * 100.0 / range) + " " + String.valueOf(HillConstants.TP));
                continue;
            }
            if (vFlag && t < HillConstants.THETA && delta * 100.0 / range > HillConstants.TPV && HillConstants.THETA > 0.0 && HillConstants.TPV > 0.0) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps != null) {
                    maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], t, "Current point's delta angle > Pref.TPV:" + String.valueOf(t) + " " + String.valueOf(HillConstants.THETA));
                }
            }
            if (ds != null) {
                if (delta > 499.0) {
                    delta = 499.0;
                }
                int[] nArray = ds[i];
                int n = (int)delta;
                nArray[n] = nArray[n] + 1;
            }
            prevVFlag = vFlag;
        }
        if (HillConstants.BELL_MASK && (bellFlag = AlgotithmUtils.checkBellShape(xs, ys, sdf, sd))) {
            int i7;
            maxY = 0.0;
            int maxI = -1;
            for (i7 = ys.length / HillConstants.BELL_CHECK_START; i7 < ys.length; ++i7) {
                double yy = ys[i7];
                if (HillConstants.BELL_ABS) {
                    yy = Math.abs(ys[i7]);
                }
                if (!(yy > maxY)) continue;
                maxY = yy;
                maxI = i7;
            }
            for (int j = 0; j < list.size(); ++j) {
                String line = (String)list.get(j);
                int k = line.indexOf(":");
                int l = Integer.parseInt(line.substring(0, k));
                flags[l] = false;
            }
            for (i7 = ys.length - 1; i7 >= ys.length / HillConstants.BELL_CHECK_START; --i7) {
                double td;
                double yy = ys[i7];
                if (HillConstants.BELL_ABS) {
                    yy = Math.abs(ys[i7]);
                }
                if (Math.abs(yy - maxY) < 1.0E-6) {
                    int k = i7 / dn;
                    for (int j = k * dn; j < k * dn + dn; ++j) {
                        if (j >= flags.length) continue;
                        flags[j] = true;
                        if (maps == null) continue;
                        maps[j] = null;
                    }
                    break;
                }
                if (!flags[i7] || !((td = ys[maxI] * ys[i7]) > 0.0 && yy < maxY * 0.8) && !(td < 0.0)) continue;
                flags[i7] = false;
                if (maps == null) continue;
                maps[i7] = AlgotithmUtils.maskInfoMap(xs[i7], ys[i7], ys[i7], "bell y<maxY:" + String.valueOf(ys[i7]) + " " + String.valueOf(maxY));
            }
            return flags;
        }
        no = xs.length / HillConstants.MASK;
        for (i = 0; i < no && list.size() != 0; ++i) {
            int maxj = -1;
            int maxl = -1;
            double maxd = -1.7976931348623157E308;
            for (int j = 0; j < list.size(); ++j) {
                String line = (String)list.get(j);
                int k = line.indexOf(":");
                int l = Integer.parseInt(line.substring(0, k));
                double d = Double.parseDouble(line.substring(k + 1));
                if (!(d > maxd)) continue;
                maxd = d;
                maxl = l;
                maxj = j;
            }
            flags[maxl] = false;
            list.remove(maxj);
        }
        for (i = 0; i < xs.length; ++i) {
            if (!flags[i] || maps == null) continue;
            maps[i] = null;
        }
        if (HillConstants.USER_MASK != null && HillConstants.USER_MASK.length() > 0) {
            int l = flags.length;
            StringTokenizer toks = new StringTokenizer(HillConstants.USER_MASK, " ,");
            while (toks.hasMoreTokens()) {
                int k;
                String tok = toks.nextToken();
                if (tok.startsWith("-")) {
                    k = Integer.parseInt(tok.substring(1));
                    flags[l - 1 - k] = false;
                    continue;
                }
                k = Integer.parseInt(tok);
                flags[k] = false;
            }
        }
        return flags;
    }

    public static boolean[] maskDif1(double[] xs, double[] ys, int[][] ds, double[] ms) {
        int i;
        boolean[] flags = new boolean[xs.length];
        for (int i2 = 0; i2 < xs.length; ++i2) {
            flags[i2] = true;
        }
        if (xs.length < 3) {
            return flags;
        }
        int no = 0;
        double mean = 0.0;
        for (int i3 = 0; i3 < xs.length; ++i3) {
            mean += ys[i3];
            ++no;
        }
        mean /= (double)no;
        double dev = 0.0;
        for (int i4 = 0; i4 < xs.length; ++i4) {
            double delta = ys[i4] - mean;
            dev += delta * delta;
        }
        dev = Math.sqrt(dev / (double)no);
        if (HillConstants.P0 > 0.0 && Math.abs(ys[0]) > HillConstants.P0) {
            flags[0] = false;
        }
        no = xs.length - 1;
        ArrayList<String> list = new ArrayList<String>();
        for (i = 1; i < xs.length; ++i) {
            if (Math.abs(ys[i]) > HillConstants.PMAX) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                continue;
            }
            double ratio = Math.abs(ys[i] - mean) / dev;
            if (ratio > HillConstants.TR) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                continue;
            }
            double delta0 = Math.abs(ys[i] - ys[i - 1]);
            double delta2 = 1.0E7;
            double delta1 = 1.0E7;
            boolean vFlag = false;
            double t1 = 0.0;
            if (i > 1) {
                t1 = AlgotithmUtils.calcTheta(xs, ys, i - 2, i - 1, i);
            }
            double t2 = 0.0;
            if (i < no) {
                if ((ys[i] - ys[i - 1]) * (ys[i] - ys[i + 1]) > 0.0) {
                    vFlag = true;
                }
                t2 = AlgotithmUtils.calcTheta(xs, ys, i - 1, i, i + 1);
            }
            double t = 0.0;
            t = !vFlag ? Math.max(t1, t2) : Math.min(t1, t2);
            if (i == no) {
                delta1 = Math.abs(ys[no] - (xs[no] - xs[no - 2]) * (ys[no - 1] - ys[no - 2]) / (xs[no - 1] - xs[no - 2]) - ys[no - 2]);
            } else {
                delta1 = Math.abs(ys[i] - (xs[i] - xs[i - 1]) * (ys[i + 1] - ys[i - 1]) / (xs[i + 1] - xs[i - 1]) - ys[i - 1]);
                delta2 = Math.abs(ys[i] - ys[i + 1]);
            }
            double delta = 1000000.0;
            delta = Math.min(delta0, delta1);
            delta = Math.min(delta2, delta);
            if (i == no || i == no - 1) {
                if (ys[i] - ys[i - 1] > 0.0 && delta > HillConstants.TPV) {
                    list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                } else if (delta > HillConstants.TPN) {
                    list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                }
            } else if (delta > HillConstants.TP) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
            } else if (t < HillConstants.THETA && delta > HillConstants.TPV) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
            }
            if (ds == null) continue;
            if (delta > 499.0) {
                delta = 499.0;
            }
            int[] nArray = ds[i];
            int n = (int)delta;
            nArray[n] = nArray[n] + 1;
        }
        no = xs.length / HillConstants.MASK;
        for (i = 0; i < no && list.size() != 0; ++i) {
            int maxj = -1;
            int maxl = -1;
            double maxd = -100000.0;
            for (int j = 0; j < list.size(); ++j) {
                String line = (String)list.get(j);
                int k = line.indexOf(":");
                int l = Integer.parseInt(line.substring(0, k));
                double d = Double.parseDouble(line.substring(k + 1));
                if (!(d > maxd)) continue;
                maxd = d;
                maxl = l;
                maxj = j;
            }
            flags[maxl] = false;
            list.remove(maxj);
        }
        return flags;
    }

    public static boolean[] maskDif2(double[] xs, double[] ys, int[][] ds, double[] ms) {
        int i;
        boolean[] flags = new boolean[xs.length];
        for (int i2 = 0; i2 < xs.length; ++i2) {
            flags[i2] = true;
        }
        if (xs.length < 3) {
            return flags;
        }
        int no = 0;
        double mean = 0.0;
        for (int i3 = 0; i3 < xs.length; ++i3) {
            mean += ys[i3];
            ++no;
        }
        mean /= (double)no;
        double dev = 0.0;
        for (int i4 = 0; i4 < xs.length; ++i4) {
            double delta = ys[i4] - mean;
            dev += delta * delta;
        }
        dev = Math.sqrt(dev / (double)no);
        if (HillConstants.PMAX > 0.0 && Math.abs(ys[0]) > HillConstants.PMAX) {
            flags[0] = false;
        }
        no = xs.length - 1;
        ArrayList<String> list = new ArrayList<String>();
        boolean prevVFlag = false;
        for (i = 1; i < xs.length; ++i) {
            if (HillConstants.PMAX > 0.0 && Math.abs(ys[i]) > HillConstants.PMAX) {
                System.out.println("Abs(y)>Pref.PMAX");
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                continue;
            }
            double ratio = Math.abs(ys[i] - mean) / dev;
            if (HillConstants.TR > 0.0 && ratio > HillConstants.TR) {
                System.out.println("Deviation from mean > Pref.TR");
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                continue;
            }
            boolean vFlag = false;
            if (i < no && (ys[i] - ys[i - 1]) * (ys[i] - ys[i + 1]) > 0.0) {
                vFlag = true;
            }
            double t1 = 0.0;
            if (i > 1) {
                t1 = AlgotithmUtils.calcTheta(xs, ys, i - 2, i - 1, i);
            }
            double t2 = 0.0;
            if (i < no) {
                t2 = AlgotithmUtils.calcTheta(xs, ys, i - 1, i, i + 1);
            }
            double t = 0.0;
            t = !vFlag ? Math.max(t1, t2) : Math.min(t1, t2);
            double delta0 = Math.abs(ys[i] - ys[i - 1]);
            double delta1 = 1.0E7;
            double delta2 = 1.0E7;
            if (i == no) {
                delta1 = Math.abs(ys[no] - (xs[no] - xs[no - 2]) * (ys[no - 1] - ys[no - 2]) / (xs[no - 1] - xs[no - 2]) - ys[no - 2]);
            } else {
                delta1 = Math.abs(ys[i] - (xs[i] - xs[i - 1]) * (ys[i + 1] - ys[i - 1]) / (xs[i + 1] - xs[i - 1]) - ys[i - 1]);
                delta2 = Math.abs(ys[i] - ys[i + 1]);
            }
            double delta = 1000000.0;
            delta = Math.min(delta0, delta1);
            delta = Math.min(delta2, delta);
            System.out.println(i + "::" + delta0 + ":" + delta1 + ":" + delta2 + ":" + t1 + ":" + t2);
            if (prevVFlag && i == no) {
                if (!(delta > HillConstants.TPN) || !(HillConstants.TPN > 0.0)) continue;
                System.out.println(delta + ":" + HillConstants.TPN + ":Last point's delta > Pref.TPN");
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                continue;
            }
            if (i != no && delta > HillConstants.TP && HillConstants.TP > 0.0) {
                System.out.println(delta + ":" + HillConstants.TP + ":Current point's delta > Pref.TP");
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                continue;
            }
            if (vFlag && t < HillConstants.THETA && delta > HillConstants.TPV && HillConstants.THETA > 0.0 && HillConstants.TPV > 0.0) {
                System.out.println(i + ":" + t + ":" + HillConstants.THETA + ":" + delta + ":" + HillConstants.TPN + ":Current point's delta > Pref.TPV");
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
            }
            if (ds != null) {
                if (delta > 499.0) {
                    delta = 499.0;
                }
                int[] nArray = ds[i];
                int n = (int)delta;
                nArray[n] = nArray[n] + 1;
            }
            prevVFlag = vFlag;
        }
        no = xs.length / HillConstants.MASK;
        for (i = 0; i < no && list.size() != 0; ++i) {
            int maxj = -1;
            int maxl = -1;
            double maxd = -100000.0;
            for (int j = 0; j < list.size(); ++j) {
                String line = (String)list.get(j);
                int k = line.indexOf(":");
                int l = Integer.parseInt(line.substring(0, k));
                double d = Double.parseDouble(line.substring(k + 1));
                if (!(d > maxd)) continue;
                maxd = d;
                maxl = l;
                maxj = j;
            }
            flags[maxl] = false;
            list.remove(maxj);
        }
        return flags;
    }

    public static boolean[] maskDif3(double[] xs, double[] ys, int[][] ds, double[] ms, HashMap<String, String>[] maps) {
        int i;
        boolean[] flags = new boolean[xs.length];
        for (int i2 = 0; i2 < xs.length; ++i2) {
            flags[i2] = true;
        }
        if (xs.length < 3) {
            return flags;
        }
        int no = 0;
        double mean = 0.0;
        for (int i3 = 0; i3 < xs.length; ++i3) {
            mean += ys[i3];
            ++no;
        }
        mean /= (double)no;
        double dev = 0.0;
        for (int i4 = 0; i4 < xs.length; ++i4) {
            double delta = ys[i4] - mean;
            dev += delta * delta;
        }
        dev = Math.sqrt(dev / (double)no);
        if (HillConstants.PMAX > 0.0 && Math.abs(ys[0]) > HillConstants.PMAX) {
            flags[0] = false;
            if (maps != null) {
                maps[0] = AlgotithmUtils.maskInfoMap(xs[0], ys[0], ys[0], "abs(y0)>Pref.PMAX:" + String.valueOf(ys[0]) + " " + String.valueOf(HillConstants.PMAX));
            }
        }
        no = xs.length - 1;
        ArrayList<String> list = new ArrayList<String>();
        boolean prevVFlag = false;
        for (i = 1; i < xs.length; ++i) {
            if (HillConstants.PMAX > 0.0 && Math.abs(ys[i]) > HillConstants.PMAX) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps == null) continue;
                maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], ys[i], "abs(y)>Pref.PMAX:" + String.valueOf(ys[i]) + " " + String.valueOf(HillConstants.PMAX));
                continue;
            }
            double ratio = Math.abs(ys[i] - mean) / dev;
            if (HillConstants.TR > 0.0 && ratio > HillConstants.TR) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps == null) continue;
                maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], ratio, "(resp-mean)/std > Pref.TR:" + String.valueOf(ratio) + " " + String.valueOf(HillConstants.TR));
                continue;
            }
            boolean vFlag = false;
            if (i < no && (ys[i] - ys[i - 1]) * (ys[i] - ys[i + 1]) > 0.0) {
                vFlag = true;
            }
            double t1 = 0.0;
            if (i > 1) {
                t1 = AlgotithmUtils.calcTheta(xs, ys, i - 2, i - 1, i);
            }
            double t2 = 0.0;
            if (i < no) {
                t2 = AlgotithmUtils.calcTheta(xs, ys, i - 1, i, i + 1);
            }
            double t = 0.0;
            t = !vFlag ? Math.max(t1, t2) : Math.min(t1, t2);
            double delta0 = Math.abs(ys[i] - ys[i - 1]);
            double delta1 = 1.0E7;
            double delta2 = 1.0E7;
            if (i == no) {
                delta1 = Math.abs(ys[no] - (xs[no] - xs[no - 2]) * (ys[no - 1] - ys[no - 2]) / (xs[no - 1] - xs[no - 2]) - ys[no - 2]);
            } else {
                delta1 = Math.abs(ys[i] - (xs[i] - xs[i - 1]) * (ys[i + 1] - ys[i - 1]) / (xs[i + 1] - xs[i - 1]) - ys[i - 1]);
                delta2 = Math.abs(ys[i] - ys[i + 1]);
            }
            double delta = 1000000.0;
            delta = Math.min(delta0, delta1);
            delta = Math.min(delta2, delta);
            if (prevVFlag && i == no) {
                if (!(delta > HillConstants.TPN) || !(HillConstants.TPN > 0.0)) continue;
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps == null) continue;
                maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], delta, "Last point's delta distance > Pref.TPN:" + String.valueOf(delta) + " " + String.valueOf(HillConstants.TPN));
                continue;
            }
            if (i != no && delta > HillConstants.TP && HillConstants.TP > 0.0) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps == null) continue;
                maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], delta, "Current point's delta distance > Pref.TP:" + String.valueOf(delta) + " " + String.valueOf(HillConstants.TP));
                continue;
            }
            if (vFlag && t < HillConstants.THETA && delta > HillConstants.TPV && HillConstants.THETA > 0.0 && HillConstants.TPV > 0.0) {
                list.add(String.valueOf(i) + ":" + String.valueOf(ys[i]));
                if (maps != null) {
                    maps[i] = AlgotithmUtils.maskInfoMap(xs[i], ys[i], t, "Current point's delta angle > Pref.TPV:" + String.valueOf(t) + " " + String.valueOf(HillConstants.THETA));
                }
            }
            if (ds != null) {
                if (delta > 499.0) {
                    delta = 499.0;
                }
                int[] nArray = ds[i];
                int n = (int)delta;
                nArray[n] = nArray[n] + 1;
            }
            prevVFlag = vFlag;
        }
        no = xs.length / HillConstants.MASK;
        for (i = 0; i < no && list.size() != 0; ++i) {
            int maxj = -1;
            int maxl = -1;
            double maxd = -100000.0;
            for (int j = 0; j < list.size(); ++j) {
                String line = (String)list.get(j);
                int k = line.indexOf(":");
                int l = Integer.parseInt(line.substring(0, k));
                double d = Double.parseDouble(line.substring(k + 1));
                if (!(d > maxd)) continue;
                maxd = d;
                maxl = l;
                maxj = j;
            }
            flags[maxl] = false;
            list.remove(maxj);
        }
        for (i = 0; i < xs.length; ++i) {
            if (!flags[i] || maps == null) continue;
            maps[i] = null;
        }
        return flags;
    }
}

