% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rdca_package.R
\name{decline_predict}
\alias{decline_predict}
\title{Arps decline prediction}
\usage{
decline_predict(decline_lst, time_lst)
}
\arguments{
\item{decline_lst}{a list object of class 'decline'}

\item{time_lst}{a list object of class 'time'}
}
\value{
a data frame of decline estimates according to the class of 'decline_lst' and 'time_lst' objects
}
\description{
Create a data frame of decline predictions according to the class of 'decline_lst' and 'time_lst' objects
}
\examples{
decline_param_1 <- decline_param(input_unit = "Field", output_unit = "Field",
fluid = "oil",
model = "exponential", qi = 1000, Di = 0.15, b = 0, q_abnd = NULL)
decline_time_1 <- decline_time(c(1:7300), unit = "day")
decline_predict_1 <- decline_predict(decline_param_1, decline_time_1)

head(decline_predict_1)

decline_param_2 <- decline_param(input_unit = "Field", output_unit = "SI",
fluid = "oil",
model = "hyperbolic", qi = 15000, Di = 0.1, b = 0.95, q_abnd = 200)
decline_time_2 <- decline_time(seq(as.Date("2016/04/15"), by = "days",
length.out = 3600), unit = "date")
decline_predict_2 <- decline_predict(decline_param_2, decline_time_2)

head(decline_predict_2)

}
\references{
\insertRef{Arps1945}{Rdca}

\insertRef{Robertson1988}{Rdca}
}
