% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNOMEDcodelist.R
\name{expandSNOMED}
\alias{expandSNOMED}
\alias{contractSNOMED}
\alias{showCodelistHierarchy}
\title{Expand or contract a SNOMEDcodelist}
\usage{
expandSNOMED(x, SNOMED = getSNOMED(), ...)

contractSNOMED(x, SNOMED = getSNOMED(), ...)

showCodelistHierarchy(
  x,
  SNOMED = getSNOMED(),
  max_excluded_descendants = 200,
  ...
)
}
\arguments{
\item{x}{SNOMEDcodelist to expand or contract. If x is not a
SNOMEDcodelist, it is coerced to one by as.SNOMEDcodelist}

\item{SNOMED}{environment containing a SNOMED dictionary}

\item{...}{other arguments to pass to as.SNOMEDcodelist}

\item{max_excluded_descendants}{(integer) whether to show excluded
descendants as long as they do not exceed this number (a
limit is suggested to avoid the program crashing if there
are too many descendants). If this number is exceeded, the
program will initially try to include children only, and if
there are still too many, it will ignore all descendants.
An 'included' column is added to the codelist
showing which terms are included. This can make it easy to see
if a codelist is consistent with the SNOMED CT ontology.}
}
\value{
An object of class 'SNOMEDcodelist' with attribute
   Expanded = TRUE
}
\description{
SNOMEDcodelist is an S3 class for sets of SNOMED concepts.
In the 'contracted' form, it may contain only parents and not
child terms (to create a more succinct list). The 'Expanded'
form contains all concepts. The output of 'showCodelistHierarchy'
includes all hierarchies contained within the codelist in a 
format suitable for display.
}
\examples{
SNOMED <- sampleSNOMED()

my_concepts <- SNOMEDconcept('Heart failure')
my_codelist <- SNOMEDcodelist(data.frame(conceptId = my_concepts,
  include_desc = TRUE))
expanded_codelist <- expandSNOMED(my_codelist)
contractSNOMED(expanded_codelist)
}
\seealso{
Other SNOMEDcodelist functions: 
\code{\link{SNOMEDcodelist}()},
\code{\link{export}()},
\code{\link{is.SNOMEDcodelist}()},
\code{\link{print.SNOMEDcodelist}()}

Other SNOMEDcodelist functions: 
\code{\link{SNOMEDcodelist}()},
\code{\link{export}()},
\code{\link{is.SNOMEDcodelist}()},
\code{\link{print.SNOMEDcodelist}()}

Other SNOMEDcodelist functions: 
\code{\link{SNOMEDcodelist}()},
\code{\link{export}()},
\code{\link{is.SNOMEDcodelist}()},
\code{\link{print.SNOMEDcodelist}()}
}
\concept{SNOMEDcodelist functions}
