% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_SPE.R
\name{do.spe}
\alias{do.spe}
\title{Stochastic Proximity Embedding}
\usage{
do.spe(X, ndim = 2, proximity = function(x) {     dist(x, method =
  "euclidean") }, C = 50, S = 50, lambda = 1, drate = 0.9)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{proximity}{a function for constructing proximity matrix from original data dimension.}

\item{C}{the number of cycles to be run; after each cycle, learning parameter}

\item{S}{the number of updates for each cycle.}

\item{lambda}{initial learning parameter.}

\item{drate}{multiplier for \code{lambda} at each cycle; should be a positive real number in \eqn{(0,1).}}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
One of drawbacks for Multidimensional Scaling or Sammon mapping is that
they have quadratic computational complexity with respect to the number of data.
Stochastic Proximity Embedding (SPE) adopts stochastic update rule in that
its computational speed is much improved. It performs \code{C} number of cycles,
where for each cycle, it randomly selects two data points and updates their
locations correspondingly \code{S} times. After each cycle, learning parameter \eqn{\lambda}
is multiplied by \code{drate}, becoming smaller in magnitude.
}
\examples{
## generate sample data
X = aux.gensamples()

## compare with mds using 2 distance metrics
outMDS <- do.mds(X, ndim=2)
out1 <- do.spe(X, ndim=2)
out2 <- do.spe(X, ndim=2, proximity=function(x){dist(x, method="manhattan")})

## Visualize
par(mfrow=c(1,3))
plot(outMDS$Y[,1], outMDS$Y[,2], main="MDS")
plot(out1$Y[,1], out1$Y[,2], main="SPE with L2 norm")
plot(out2$Y[,1], out2$Y[,2], main="SPE with L1 norm")

}
\references{
\insertRef{agrafiotis_stochastic_2003}{Rdimtools}
}
\author{
Kisung You
}
