/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.command.CommandService;
import org.drools.time.InternalSchedulerService;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.SelfRemovalJob;
import org.drools.time.SelfRemovalJobContext;
import org.drools.time.Trigger;
import org.drools.time.impl.DefaultTimerJobInstance;
import org.drools.time.impl.TimerJobFactoryManager;
import org.drools.time.impl.TimerJobInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackableTimeJobFactoryManager
implements TimerJobFactoryManager {
    private Map<Long, TimerJobInstance> timerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();

    @Override
    public TimerJobInstance createTimerJobInstance(Job job, JobContext ctx, Trigger trigger, JobHandle handle, InternalSchedulerService scheduler) {
        ctx.setJobHandle(handle);
        DefaultTimerJobInstance jobInstance = new DefaultTimerJobInstance(new SelfRemovalJob(job), new SelfRemovalJobContext(ctx, this.timerInstances), trigger, handle, scheduler);
        return jobInstance;
    }

    @Override
    public void addTimerJobInstance(TimerJobInstance instance) {
        this.timerInstances.put(instance.getJobHandle().getId(), instance);
    }

    @Override
    public void removeTimerJobInstance(TimerJobInstance instance) {
        this.timerInstances.remove(instance.getJobHandle().getId());
    }

    @Override
    public Collection<TimerJobInstance> getTimerJobInstances() {
        return this.timerInstances.values();
    }

    @Override
    public void setCommandService(CommandService commandService) {
    }

    @Override
    public CommandService getCommandService() {
        return null;
    }
}

