/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.process;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.Context;
import org.kie.internal.command.ProcessInstanceIdCommand;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SetProcessInstanceVariablesCommand
implements GenericCommand<Void>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 7802415761845739379L;
    @XmlAttribute(required=true)
    private Long processInstanceId;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="variables")
    private Map<String, Object> variables = new HashMap<String, Object>();

    public SetProcessInstanceVariablesCommand() {
    }

    public SetProcessInstanceVariablesCommand(long processInstanceId, Map<String, Object> variables) {
        this.processInstanceId = processInstanceId;
        this.variables = variables;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    @Override
    public Void execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId.longValue());
        if (processInstance != null && this.variables != null) {
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                ((WorkflowProcessInstance)processInstance).setVariable(entry.getKey(), entry.getValue());
            }
        }
        return null;
    }

    public String toString() {
        String result = "WorkflowProcessInstance processInstance = (WorkflowProcessInstance) session.getProcessInstance(" + this.processInstanceId + ");";
        if (this.variables != null) {
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                result = result + "\nprocessInstance.setVariable(\"" + entry.getKey() + "\", " + (entry.getValue() == null ? "null" : entry.getValue().toString()) + ");";
            }
        }
        return result;
    }
}

