% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dailymean.fun.R
\name{dailymean.fun}
\alias{dailymean.fun}
\title{Seasonal pattern  of the mean values}
\usage{
dailymean.fun(
  X_T,
  method = "moving",
  Nyear,
  day.year = NULL,
  harmonics = 3,
  window = 3
)
}
\arguments{
\item{X_T}{A numeric vector  of daily observations.   Its length  has to be higher than 365.}

\item{method}{A character string indicating the estimation procedure:
\code{"harmonic"} or \code{"moving"}.}

\item{Nyear}{Integer. Number of  observed years.   First and last year may  have incomplete records.}

\item{day.year}{Vector  of integer  values in (1:365) giving the day  of the year where the observation was recorded.
If it is null,  records of complete years  are assumed.}

\item{harmonics}{Integer number of harmonics used in the estimation. Only used if \code{method=='harmonic'}.}

\item{window}{Integer width of the moving window, which must be  an odd number. Only used if \code{method=='moving'}.}
}
\value{
A numeric vector of length 365. Each element  is the estimated  mean  at a day of the year.
}
\description{
This function estimates   the seasonal pattern  of the mean in a daily sequence of variables, that is the mean value of the variable at each day of the year.
}
\details{
This function can be used in a preliminary analysis of data, in order to  determine if the data show a seasonal behaviour, and
to estimate  the seasonal component.

 Two  approaches are implemented to calculate the seasonal  pattern of the means, one based on linear combination of harmonics
 and the other on centered moving averages. In the last case, if \code{window=2p+1}, values obsered at  days in the interval \eqn{(t-p, t+p)}
 over all the years are used to calculate the mean  at \eqn{t}.
If \code{window=1}, only values obsered at  day \eqn{t} are used to calculate the mean
}
\examples{
dailymean.fun(TX_Zaragoza$TX, method = 'moving', window = 1, Nyear = 66)
}
\seealso{
\code{\link{std.fun}}, \code{\link{dailysd.fun}}
}
