% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N.plot.R
\name{N.plot}
\alias{N.plot}
\title{Number of Records Plot}
\usage{
N.plot(
  X,
  weights = function(t) 1,
  record = c(FU = 1, FL = 1, BU = 1, BL = 1),
  backward = c("T", "t"),
  point.col = c(FU = "red", FL = "blue", BU = "red", BL = "blue"),
  point.shape = c(FU = 19, FL = 19, BU = 4, BL = 4),
  conf.int = TRUE,
  conf.level = 0.9,
  conf.aes = c("ribbon", "errorbar"),
  conf.col = "grey69"
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series,
e.g., if \code{function(t) t-1} then \eqn{\omega_t = t-1}.}

\item{record}{Logical vector. Vector with four elements indicating if 
forward upper, forward lower, backward upper and backward lower are going
to be shown, respectively. Logical values or 0,1 values are accepted.}

\item{backward}{A character string \code{"T"} or \code{"t"} indicating if 
the backward number of records shown are calculated up to time \eqn{t} in 
the backward series \eqn{\{X_T,\ldots,X_1\}} or in the series 
\eqn{\{X_t,\ldots,X_1\}}. While the first option considers the evolution 
of a series of records observed up to time \eqn{T}, the second considers 
that until each time \eqn{t} the series has only been observed up to 
\eqn{t}.}

\item{point.col, point.shape}{Vector with four elements indicating the colour
and shape of the points. Every one of the four elements represents forward
upper, forward lower, backward upper and backward lower, respectively.}

\item{conf.int}{Logical. Indicates if the CIs are also shown.}

\item{conf.level}{(If \code{conf.int == TRUE}) Confidence level of the CIs.}

\item{conf.aes}{(If \code{conf.int == TRUE}) A character string indicating 
the aesthetic to display for the CIs, \code{"ribbon"} (grey area) or 
\code{"errorbar"} (vertical lines).}

\item{conf.col}{Colour used to plot the expected value and (if 
\code{conf.int == TRUE}) CIs.}
}
\value{
A ggplot object.
}
\description{
This function builds a ggplot object to compare the sample
  means of the (weighted) number of records in a vector up to time \eqn{t}, 
  \eqn{\bar N_{t.}^\omega}, and the expected values 
  \eqn{\textrm{E}(N_t^{\omega})} 
  under the classical record model (i.e., of IID continuous RVs).
}
\details{
This plot is associated to the test \code{\link{N.test}}.
  It calculates the sample means of the number of records in a set of
  vectors up to every time \eqn{t} (see \code{\link{Nmean.record}}). 
  These sample means \eqn{\bar N_{t.}^\omega} are calculated from the sample of
  \eqn{M} values obtained from \eqn{M} vectors, the columns of matrix 
  \code{X}. Then, these values are plotted and compared with the expected 
  values \eqn{\textrm{E}(N_t^{\omega})} and their confidence intervals (CIs), under
  the hypothesis of the classical record model. The CIs of 
  \eqn{\bar N_{t.}^\omega} uses the fact that, under the classical record 
  model, the statistic is asymptotically Normal.
  
  The plot can show the four types of record at the same time (i.e., 
  forward upper, forward lower, backward upper and backward lower).
  In their interpretations one must be careful, for forward records 
  each time \eqn{t} corresponds to the same year of observation, but for 
  the backward series, time \eqn{t} corresponds to the year of observation
  \eqn{T-t+1} where \eqn{T} is the total number of observations in every 
  series. Two types of backward records can be considered (see argument
  \code{backward}).
  
  More details of this plot are shown in Cebrián, Castillo-Mateo, Asín 
  (2021).
}
\examples{
# Plot at Zaragoza, with linear weights and error bar as CIs aesthetic
N.plot(ZaragozaSeries, weights = function(t) t-1, conf.aes = "errorbar")

# Plot only upper records
N.plot(ZaragozaSeries, record = c(1, 0, 1, 0))

# Change point colour and shape
Zplot <- N.plot(ZaragozaSeries, 
  point.col = c("red", "red", "blue", "blue"), 
  point.shape = c(19, 4, 19, 4))

## Not run: Load package ggplot2 to change the plot
#library("ggplot2")
## Remove legend
#Zplot + ggplot2::theme(legend.position = "none")
## Fancy axis
# Zplot + 
#   ggplot2::scale_x_continuous(name = "Year (forward)",
#     breaks = c(10, 30, 50, 70), 
#     labels=c("1960", "1980", "2000", "2020"), 
#     sec.axis = ggplot2::sec_axis(~ nrow(ZaragozaSeries) - . + 1951, name = "Year (backward)")) +
#   ggplot2::theme(axis.title.x = ggplot2::element_text(colour = "red"), 
#     axis.text.x = ggplot2::element_text(colour = "red"),
#     axis.title.x.top = ggplot2::element_text(colour = "blue"), 
#     axis.text.x.top = ggplot2::element_text(colour = "blue"))
}
\references{
Cebrián A, Castillo-Mateo J, Asín J (2021).
“Record Tests to Detect Non Stationarity in the Tails with an Application to Climate Change.”
Available at Research Square \doi{10.21203/rs.3.rs-214787/v1}
}
\seealso{
\code{\link{N.record}}, \code{\link{N.test}}, 
  \code{\link{foster.test}}, \code{\link{foster.plot}}
}
\author{
Jorge Castillo-Mateo
}
