% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegSDCcomp.R
\encoding{UTF8}
\name{RegSDCcomp}
\alias{RegSDCcomp}
\title{Regression-based SDC Tools - Component score correlation control}
\usage{
RegSDCcomp(
  y,
  compCorr = NA,
  x = NULL,
  doSVD = FALSE,
  makeunique = TRUE,
  ensureIntercept = TRUE
)
}
\arguments{
\item{y}{Matrix of confidential variables}

\item{compCorr}{Required component score  correlations (possibly recycled)}

\item{x}{Matrix of non-confidential variables}

\item{doSVD}{SVD when TRUE and QR when FALSE}

\item{makeunique}{Parameter to be used in GenQR}

\item{ensureIntercept}{Whether to ensure/include a constant term. Non-NULL x is subjected to \code{\link{EnsureIntercept}}}
}
\value{
Generated version of y
}
\description{
Implementation of equation 8 in the paper.
}
\details{
NA component score correlation means independent random. Input matrices are subjected to \code{\link{EnsureMatrix}}.
}
\examples{
x <- matrix(1:10, 10, 1)
y <- matrix(rnorm(30) + 1:30, 10, 3)

# Same as IPSO (RegSDCipso)
RegSDCcomp(y, NA, x)

# Using QR and SVD
yQR <- RegSDCcomp(y, c(0.1, 0.2, NA), x)
ySVD <- RegSDCcomp(y, c(0.1, 0.2, NA), x, doSVD = TRUE)

# Calculation of residuals
r <- residuals(lm(y ~ x))
rQR <- residuals(lm(yQR ~ x))
rSVD <- residuals(lm(ySVD ~ x))

# Correlations for two first components as required
diag(cor(GenQR(r)$Q, GenQR(rQR)$Q))
diag(cor(GenQR(r, doSVD = TRUE)$Q, GenQR(rSVD, doSVD = TRUE)$Q))

# Identical covariance matrices
cov(yQR) - cov(ySVD)
cov(rQR) - cov(rSVD)

# Identical regression results
summary(lm(y[, 1] ~ x))
summary(lm(yQR[, 1] ~ x))
summary(lm(ySVD[, 1] ~ x))
}
\author{
Øyvind Langsrud
}
