% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalueBound.R
\name{pvalueBound}
\alias{pvalueBound}
\title{Bound for the p-values entering the harmonic mean chi-squared test}
\usage{
pvalueBound(alpha, n, type = c("necessary", "sufficient"))
}
\arguments{
\item{alpha}{Numeric vector specifying the significance level.}

\item{n}{The number of p-values.}

\item{type}{Either "necessary" (default) or "sufficient".
If "necessary", the necessary bounds are computed.
If "sufficient", the sufficient bounds are computed.}
}
\value{
The bound for the p-values.
}
\description{
Necessary or sufficient bounds for significance of the harmonic mean
chi-squared test are computed for n one-sided p-values.
}
\examples{
pvalueBound(alpha = 0.025^2, n = 2, type = "necessary")
pvalueBound(alpha = 0.025^2, n = 2, type = "sufficient")
}
\references{
Held, L. (2020). The harmonic mean chi-squared test to substantiate
scientific findings. \emph{Journal of the Royal Statistical Society: Series C
(Applied Statistics)}, \bold{69}, 697-708. \doi{10.1111/rssc.12410}
}
\seealso{
\code{\link{hMeanChiSq}}
}
\author{
Leonhard Held
}
