/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.rdata;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTableCellProperties;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.wml.Color;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.Text;
import org.lysis.rdata.RAtomicInterface;
import org.lysis.reporters.pptx4r.elements.Utils;
import org.lysis.reporters.pptx4r.tools.Format;
import org.lysis.reporters.tables.TableLayoutBase;
import org.lysis.reporters.tables.TableLayoutDOCX;
import org.lysis.reporters.tables.TableLayoutHTML;
import org.lysis.reporters.tables.TableLayoutPPTX;

public class RInteger
implements RAtomicInterface {
    Vector<Integer> data;

    public RInteger(Vector<Integer> data) {
        this.data = data;
    }

    private String format(TableLayoutBase tf, double value) {
        Locale locale = new Locale(tf.getLocale_language(), tf.getLocale_region());
        NumberFormat nf = NumberFormat.getIntegerInstance(locale);
        nf.setGroupingUsed(false);
        return nf.format(value);
    }

    @Override
    public void print() {
        int i = 0;
        while (i < this.size()) {
            System.out.println(this.data.get(i).toString());
            ++i;
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Object get(int i) {
        return this.data.get(i);
    }

    @Override
    public P getP(int i, TableLayoutDOCX tf) {
        P p = new P();
        R run = new R();
        Text text = new Text();
        PPr parProperties = tf.getIntegerPar();
        RPr textProperties = tf.getIntegerText();
        BigInteger bi = new BigInteger("-2147483648");
        Long temp = new Long(this.data.get(i).longValue());
        int test = bi.compareTo(new BigInteger(temp.toString()));
        if (test == 0) {
            text.setValue("NA");
        } else {
            text.setValue(this.format(tf, this.data.get(i).intValue()));
        }
        run.getContent().add(text);
        run.setRPr(textProperties);
        p.getContent().add(run);
        p.setPPr(parProperties);
        return p;
    }

    @Override
    public P getP(int i, TableLayoutDOCX tf, String fontColor) {
        P p = new P();
        R run = new R();
        Text text = new Text();
        PPr parProperties = tf.getIntegerPar();
        RPr textProperties = (RPr)XmlUtils.deepCopy((Object)tf.getIntegerText());
        Color col = new Color();
        col.setVal(fontColor);
        textProperties.setColor(col);
        Long temp = new Long(this.data.get(i).longValue());
        BigInteger bi = new BigInteger("-2147483648");
        if (bi.compareTo(new BigInteger(temp.toString())) == 0) {
            text.setValue("NA");
        } else {
            text.setValue(this.format(tf, this.data.get(i).intValue()));
        }
        run.getContent().add(text);
        run.setRPr(textProperties);
        p.getContent().add(run);
        p.setPPr(parProperties);
        return p;
    }

    @Override
    public TcPr getCellProperties(TableLayoutDOCX tf) {
        return tf.getIntegerCell();
    }

    @Override
    public CTTableCellProperties getCellProperties(TableLayoutPPTX tf) {
        return tf.getIntegerCell();
    }

    @Override
    public CTTextBody getP(int i, TableLayoutPPTX tf) throws Exception {
        CTTextBody p = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        p.setBodyPr(pp);
        p.setLstStyle(ls);
        Long temp = new Long(this.data.get(i).longValue());
        BigInteger bi = new BigInteger("-2147483648");
        CTRegularTextRun textRun = bi.compareTo(new BigInteger(temp.toString())) == 0 ? Utils.getRun("NA") : Utils.getRun(this.format(tf, this.data.get(i).intValue()));
        textRun.setRPr(tf.getIntegerText());
        CTTextParagraph textPar = new CTTextParagraph();
        List runs = textPar.getEGTextRun();
        runs.add(textRun);
        textPar.setPPr(tf.getIntegerPar());
        p.getP().add(textPar);
        return p;
    }

    @Override
    public CTTextBody getP(int i, TableLayoutPPTX tf, String fontColor) throws Exception {
        CTTextBody p = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        p.setBodyPr(pp);
        p.setLstStyle(ls);
        Long temp = new Long(this.data.get(i).longValue());
        BigInteger bi = new BigInteger("-2147483648");
        CTRegularTextRun textRun = bi.compareTo(new BigInteger(temp.toString())) == 0 ? Utils.getRun("NA") : Utils.getRun(this.format(tf, this.data.get(i).intValue()));
        CTTextCharacterProperties chartext = (CTTextCharacterProperties)XmlUtils.deepCopy((Object)tf.getIntegerText());
        chartext.setSolidFill(Format.getCol(fontColor));
        textRun.setRPr(chartext);
        CTTextParagraph textPar = new CTTextParagraph();
        List runs = textPar.getEGTextRun();
        runs.add(textRun);
        textPar.setPPr(tf.getIntegerPar());
        p.getP().add(textPar);
        return p;
    }

    @Override
    public LinkedHashMap<String, String> getCellProperties(TableLayoutHTML tf) {
        return tf.getIntegerCell();
    }

    @Override
    public String getTdCssClass() {
        return "IntegerCell";
    }

    @Override
    public String getHTML(int i, TableLayoutHTML tf) {
        Long temp = new Long(this.data.get(i).longValue());
        BigInteger bi = new BigInteger("-2147483648");
        String out = "";
        out = String.valueOf(out) + "<p class=\"IntegerPar\"><span class=\"IntegerText\">";
        out = bi.compareTo(new BigInteger(temp.toString())) == 0 ? String.valueOf(out) + "NA" : String.valueOf(out) + this.format(tf, this.data.get(i).intValue());
        out = String.valueOf(out) + "</span></p>";
        return out;
    }

    @Override
    public String getHTML(int i, String fontColor, TableLayoutHTML tf) {
        Long temp = new Long(this.data.get(i).longValue());
        BigInteger bi = new BigInteger("-2147483648");
        String out = "";
        out = String.valueOf(out) + "<p class=\"IntegerPar\"><span class=\"IntegerText\" style=\"color:" + fontColor + ";\">";
        out = bi.compareTo(new BigInteger(temp.toString())) == 0 ? String.valueOf(out) + "NA" : String.valueOf(out) + this.format(tf, this.data.get(i).intValue());
        out = String.valueOf(out) + "</span></p>";
        return out;
    }
}

