/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.pptx4r.tools;

import java.awt.Color;

import org.docx4j.XmlUtils;
import org.docx4j.dml.CTLineProperties;
import org.docx4j.dml.CTPresetLineDashProperties;
import org.docx4j.dml.CTSRgbColor;
import org.docx4j.dml.CTSolidColorFillProperties;
import org.docx4j.dml.STPresetLineDashVal;
import org.pptx4j.jaxb.Context;

public class Format {
	
	public static CTSolidColorFillProperties getCol( String myColor ) throws Exception{
		System.setProperty("java.awt.headless", "true");
		CTSolidColorFillProperties prop = new CTSolidColorFillProperties();

		CTSRgbColor rgb = new CTSRgbColor();
        
		Color color = null;
		try{
		java.lang.reflect.Field field = Class.forName("java.awt.Color").getField(myColor.toLowerCase()); // toLowerCase because the color fields are RED or red, not Red
		color = (Color)field.get(null);
		} catch( java.lang.NoSuchFieldException e ){
			color = Color.decode(myColor);
		}
		rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});

		prop.setSrgbClr( rgb );
		return prop;
	}
		
	public static CTLineProperties getBorder (String borderColor, String borderStyle, int borderWidth, String borderSuffix) throws Exception {
		CTLineProperties border = new CTLineProperties();
		if( borderWidth > 0 && !borderStyle.equals("none") ){
			border.setSolidFill(getCol(borderColor));
			border.setW(borderWidth*12700);
			CTPresetLineDashProperties lineStyle = new CTPresetLineDashProperties();
			
		    if( borderStyle.equals("solid") )
		    	lineStyle.setVal(STPresetLineDashVal.SOLID);
		    else if( borderStyle.equals("dotted") )
		    	lineStyle.setVal( STPresetLineDashVal.SYS_DOT);
		    else if( borderStyle.equals("dashed") )
		    	lineStyle.setVal( STPresetLineDashVal.SYS_DASH);
		    else lineStyle.setVal(STPresetLineDashVal.SOLID);
	    
		    border.setPrstDash(lineStyle);
		    
		} else {
			String borderStr = "<a:ln" + borderSuffix + " xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" w=\"12700\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:noFill /><a:prstDash val=\"solid\" /><a:round /><a:headEnd type=\"none\" w=\"med\" len=\"med\" /><a:tailEnd type=\"none\" w=\"med\" len=\"med\" /></a:ln" + borderSuffix + ">";
			border = ((CTLineProperties)XmlUtils.unmarshalString(borderStr, Context.jcPML, CTLineProperties.class) );
		}
	    return border;
	}
}
