% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/addPageNumber.pptx.R
\name{addPageNumber.pptx}
\alias{addPageNumber.pptx}
\title{Insert a page number shape into a document pptx object}
\usage{
\method{addPageNumber}{pptx}(doc, value, ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object}

\item{value}{character value to add into the page number shape of the current slide.
optionnal. If missing current slide number will be used.}

\item{...}{further arguments, not used.}
}
\value{
a \code{\link{pptx}} document object
}
\description{
Insert a page number shape into the current slide of a \code{pptx} object.
}
\examples{
\dontrun{
doc.filename = "addPageNumber_example.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )
# add a slide with layout "Title Slide"
doc = addSlide( doc, slide.layout = "Title Slide" )
doc = addTitle( doc, "Presentation title" ) #set the main title
#set the sub-title
doc = addSubtitle( doc , "This document is generated with ReporteRs.")

## add a page number on the current slide
doc = addPageNumber( doc )

doc = addSlide( doc, slide.layout = "Title and Content" )
## add a page number on the current slide but 
## not the default text (slide number)
doc = addPageNumber( doc, value = "Page number text")

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{addPageNumber}}, \code{\link{addDate.pptx}}
}

