% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/writeDoc.pptx.R
\name{writeDoc.pptx}
\alias{writeDoc.pptx}
\title{Write a pptx object in a pptx file}
\usage{
\method{writeDoc}{pptx}(doc, file, ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object that has to be written.}

\item{file}{single character value, name of the file to write.}

\item{...}{further arguments, not used.}
}
\description{
Write the \code{\link{pptx}} object in a '.pptx' file.
}
\examples{
\dontrun{
doc.filename = "writeDoc_example.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{pptx}}, \code{\link{writeDoc}}
}

