/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.text;

import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.relationships.Namespaces;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.P.Hyperlink;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;

public class ExternalLink implements HTML4R, PPTX4R, DOCX4R{

	
	private String url;
	private WordprocessingMLPackage wordMLPackage;
	private SlidePart slidePart;

	public ExternalLink(String url){
		this.url = url;
	}
	
	public void setWordMLPackage(WordprocessingMLPackage wordMLPackage){
		this.wordMLPackage = wordMLPackage;
	}
	public void setSlidePart(SlidePart slidePart){
		this.slidePart = slidePart;
	}

	@Override
	public Object get_docx_elt() {
		Relationship rel;
		org.docx4j.relationships.ObjectFactory factory =
				new org.docx4j.relationships.ObjectFactory();
		rel = factory.createRelationship();
		rel.setType( Namespaces.HYPERLINK  );
		rel.setTarget(url);
		rel.setTargetMode("External");
		wordMLPackage.getMainDocumentPart().getRelationshipsPart().addRelationship(rel);
		Hyperlink hl = new Hyperlink();
		hl.setHistory(Boolean.TRUE);
		hl.setId(rel.getId());
		return hl;
	}

	@Override
	public Object get_flextable_pptx() throws Exception {
		org.docx4j.dml.CTHyperlink hyperlink = new org.docx4j.dml.CTHyperlink();
		org.docx4j.relationships.ObjectFactory factory = new org.docx4j.relationships.ObjectFactory();
		org.docx4j.relationships.Relationship rel = factory.createRelationship();
		slidePart.getRelationshipsPart().addRelationship(rel);
		
		rel.setType( Namespaces.HYPERLINK  );
        rel.setTarget(url);
        rel.setTargetMode("External");  
		hyperlink.setId(rel.getId() );
		return hyperlink;
	}

	@Override
	public String getHTML() {
		return null;
	}

	@Override
	public String getCSS() {
		return null;
	}

	@Override
	public String getJS() {
		return null;
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}
	
	
	
}
