% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addCodeBlock.pptx.R
\name{addCodeBlock.pptx}
\alias{addCodeBlock.pptx}
\title{Add a code block into a pptx object}
\usage{
\method{addCodeBlock}{pptx}(doc, file, text, par.properties = parProperties(),
  text.properties = textProperties(color = "#A7947D"), append = FALSE, ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object}

\item{file}{file. Not used if text is provided.}

\item{text}{character vector. The text to parse. Not used if file is provided.}

\item{par.properties}{code block paragraph properties. An object of class \code{\link{parProperties}}}

\item{text.properties}{code block text properties. An object of class \code{\link{textProperties}}}

\item{append}{boolean default to FALSE. If TRUE, paragraphs will be
appened in the current shape instead of beeing sent into a new shape.
Paragraphs can only be appended on shape containing paragraphs (i.e. you
can not add paragraphs after a FlexTable).}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{pptx}}.
}
\description{
Add a code block into a \code{\link{pptx}} object.
}
\examples{
\dontrun{
doc.filename = "addCodeBlock.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )
doc = addCodeBlock( doc, text = "ls -a\\nwhich -a ls" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{pptx}}, \code{\link{addCodeBlock}}
}

