/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.html4r.elements;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedHashMap;

import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tools.HTML4R;

public class RAPHAELGraphics implements HTML4R{
	private LinkedHashMap<String, String> raphael_cmds;
	private ParProperties parProperties;

	public RAPHAELGraphics(ParProperties pp){
		parProperties = pp;
		raphael_cmds = new LinkedHashMap<String, String>();
	}
	
	public void registerGraphic(String id, String file) throws UnsupportedEncodingException, IOException{
		BufferedReader in = new BufferedReader(new FileReader( file ));
		String UTF8Str="";
		String s;
		while( (s = in.readLine()) != null) {
			UTF8Str += s;
		}
		in.close();
		
		raphael_cmds.put(id, UTF8Str);
	}


	@Override
	public String getHTML() {
		String out = "";
		LinkedHashMap<String, String> ppr = parProperties.get_html_pp();
		String pStart = "<div style=\"" + Format.getJSString(ppr) + "\">";
		String pStop = "</div>";
		out += pStart;
		for (Iterator<String> it1 = raphael_cmds.keySet().iterator(); it1.hasNext();) {
			String id = it1.next();
			out += "<div id=\"" + id + "\" width=\"100%\"></div>";
		}
		out += pStop;
		return out;
	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		String out = "";
		for (Iterator<String> it1 = raphael_cmds.keySet().iterator(); it1.hasNext();) {
			String id = it1.next();
			out += raphael_cmds.get(id) + "\n";
		}
		return out;
	}

	@Override
	public boolean hasJS() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}


}
