/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.tools;

public class EMU {
	private static long inch = 914400;
	private static long centimeter = 360000;
//	private static long pixel = 12700;
	public static long getEMUFromInch( double x ){
		return (new Double( x * inch )).longValue();
	}
	public static long getEMUFromCm( double x ){
		return (new Double( x * centimeter )).longValue();
	}
	
	public static double getInchFromEMU( long x ){
		return (new Double( x / inch )).doubleValue();
	}

	public static double getCmFromEMU( long x ){
		return (new Double( x / centimeter )).doubleValue();
	}
}
