/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.formats;

import java.util.LinkedHashMap;
import org.docx4j.dml.CTTableCellProperties;
import org.docx4j.dml.STTextAnchoringType;
import org.docx4j.dml.STTextVerticalType;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.TextDirection;
import org.lysis.reporters.formats.BorderProperties;
import org.lysis.reporters.pptx4r.tools.Format;

public class CellProperties {
    private BorderProperties borderBottom;
    private BorderProperties borderLeft;
    private BorderProperties borderTop;
    private BorderProperties borderRight;
    private String verticalAlign;
    private int paddingBottom;
    private int paddingTop;
    private int paddingLeft;
    private int paddingRight;
    private String backgroundColor;
    private String textDirection;

    public CellProperties(BorderProperties borderBottom, BorderProperties borderLeft, BorderProperties borderTop, BorderProperties borderRight, String verticalAlign, int paddingBottom, int paddingTop, int paddingLeft, int paddingRight, String backgroundColor, String textDirection) {
        this.borderBottom = borderBottom;
        this.borderLeft = borderLeft;
        this.borderTop = borderTop;
        this.borderRight = borderRight;
        this.verticalAlign = verticalAlign;
        this.paddingBottom = paddingBottom;
        this.paddingTop = paddingTop;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.backgroundColor = backgroundColor;
        this.textDirection = textDirection;
    }

    public String getVerticalAlign() {
        return this.verticalAlign;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String color) {
        this.backgroundColor = color;
    }

    public BorderProperties getBorderBottom() {
        return this.borderBottom;
    }

    public String getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(String s) {
        this.textDirection = s;
    }

    public void setBorderBottom(BorderProperties borderBottom) {
        this.borderBottom = borderBottom;
    }

    public BorderProperties getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(BorderProperties borderLeft) {
        this.borderLeft = borderLeft;
    }

    public BorderProperties getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(BorderProperties borderTop) {
        this.borderTop = borderTop;
    }

    public BorderProperties getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(BorderProperties borderRight) {
        this.borderRight = borderRight;
    }

    public CellProperties getClone() {
        return new CellProperties(this.borderBottom, this.borderLeft, this.borderTop, this.borderRight, this.verticalAlign, this.paddingBottom, this.paddingTop, this.paddingLeft, this.paddingRight, this.backgroundColor, this.textDirection);
    }

    public TcPr get_docx_cp() {
        TextDirection td;
        TcPr tcPr = new TcPr();
        CTShd shd = new CTShd();
        shd.setFill(this.backgroundColor);
        tcPr.setShd(shd);
        if (this.textDirection.equals("tbrl")) {
            td = new TextDirection();
            td.setVal("tbRl");
            tcPr.setTextDirection(td);
        } else if (this.textDirection.equals("btlr")) {
            td = new TextDirection();
            td.setVal("btLr");
            tcPr.setTextDirection(td);
        }
        if (this.borderBottom.hasBorder() || this.borderLeft.hasBorder() || this.borderRight.hasBorder() || this.borderTop.hasBorder()) {
            TcPrInner.TcBorders tcb = new TcPrInner.TcBorders();
            if (this.borderBottom.hasBorder()) {
                tcb.setBottom(this.borderBottom.get_docx_bd());
            }
            if (this.borderLeft.hasBorder()) {
                tcb.setLeft(this.borderLeft.get_docx_bd());
            }
            if (this.borderRight.hasBorder()) {
                tcb.setRight(this.borderRight.get_docx_bd());
            }
            if (this.borderTop.hasBorder()) {
                tcb.setTop(this.borderTop.get_docx_bd());
            }
            tcPr.setTcBorders(tcb);
        }
        CTVerticalJc valign = new CTVerticalJc();
        if (this.verticalAlign.equals("center")) {
            valign.setVal(STVerticalJc.CENTER);
        } else if (this.verticalAlign.equals("middle")) {
            valign.setVal(STVerticalJc.CENTER);
        } else if (this.verticalAlign.equals("top")) {
            valign.setVal(STVerticalJc.TOP);
        } else if (this.verticalAlign.equals("bottom")) {
            valign.setVal(STVerticalJc.BOTTOM);
        } else {
            valign.setVal(STVerticalJc.CENTER);
        }
        tcPr.setVAlign(valign);
        if (this.paddingBottom > 0 || this.paddingTop > 0 || this.paddingLeft > 0 || this.paddingRight > 0) {
            tcPr.setTcMar(org.lysis.reporters.docx4r.tools.Format.getMargins(this.paddingBottom, this.paddingTop, this.paddingLeft, this.paddingRight));
        }
        return tcPr;
    }

    public CTTableCellProperties get_pptx_cp() throws Exception {
        CTTableCellProperties tcPr = new CTTableCellProperties();
        tcPr.setSolidFill(Format.getCol(this.backgroundColor));
        tcPr.setLnB(this.borderBottom.get_pptx_bd("B"));
        tcPr.setLnT(this.borderTop.get_pptx_bd("T"));
        tcPr.setLnR(this.borderRight.get_pptx_bd("R"));
        tcPr.setLnL(this.borderLeft.get_pptx_bd("L"));
        if (this.textDirection.equals("tbrl")) {
            tcPr.setVert(STTextVerticalType.VERT);
        } else if (this.textDirection.equals("btlr")) {
            tcPr.setVert(STTextVerticalType.VERT_270);
        }
        if (this.verticalAlign.equals("center")) {
            tcPr.setAnchor(STTextAnchoringType.CTR);
        } else if (this.verticalAlign.equals("middle")) {
            tcPr.setAnchor(STTextAnchoringType.CTR);
        } else if (this.verticalAlign.equals("top")) {
            tcPr.setAnchor(STTextAnchoringType.T);
        } else if (this.verticalAlign.equals("bottom")) {
            tcPr.setAnchor(STTextAnchoringType.B);
        } else {
            tcPr.setAnchor(STTextAnchoringType.CTR);
        }
        tcPr.setMarB(new Integer(this.paddingBottom * 12700));
        tcPr.setMarT(new Integer(this.paddingTop * 12700));
        tcPr.setMarR(new Integer(this.paddingRight * 12700));
        tcPr.setMarL(new Integer(this.paddingLeft * 12700));
        return tcPr;
    }

    public LinkedHashMap<String, String> get_html_cp() {
        LinkedHashMap<String, String> tcPr = new LinkedHashMap<String, String>();
        tcPr.put("background-color", this.backgroundColor);
        if (this.borderBottom.getBorderWidth() > 0 && !this.borderBottom.getBorderStyle().equals("none")) {
            tcPr.put("border-bottom-color", this.borderBottom.getBorderColor());
            tcPr.put("border-bottom-style", this.borderBottom.getBorderStyle());
            tcPr.put("border-bottom-width", String.valueOf(this.borderBottom.getBorderWidth()) + "px");
        }
        if (this.borderTop.getBorderWidth() > 0 && !this.borderTop.getBorderStyle().equals("none")) {
            tcPr.put("border-top-color", this.borderTop.getBorderColor());
            tcPr.put("border-top-style", this.borderTop.getBorderStyle());
            tcPr.put("border-top-width", String.valueOf(this.borderTop.getBorderWidth()) + "px");
        }
        if (this.borderRight.getBorderWidth() > 0 && !this.borderRight.getBorderStyle().equals("none")) {
            tcPr.put("border-right-color", this.borderRight.getBorderColor());
            tcPr.put("border-right-style", this.borderRight.getBorderStyle());
            tcPr.put("border-right-width", String.valueOf(this.borderRight.getBorderWidth()) + "px");
        }
        if (this.borderLeft.getBorderWidth() > 0 && !this.borderLeft.getBorderStyle().equals("none")) {
            tcPr.put("border-left-color", this.borderLeft.getBorderColor());
            tcPr.put("border-left-style", this.borderLeft.getBorderStyle());
            tcPr.put("border-left-width", String.valueOf(this.borderLeft.getBorderWidth()) + "px");
        }
        if (this.verticalAlign.equals("center")) {
            tcPr.put("vertical-align", "middle");
        } else {
            tcPr.put("vertical-align", this.verticalAlign);
        }
        tcPr.put("padding-left", String.valueOf(this.paddingLeft) + "pt");
        tcPr.put("padding-right", String.valueOf(this.paddingRight) + "pt");
        tcPr.put("padding-top", String.valueOf(this.paddingTop) + "pt");
        tcPr.put("padding-bottom", String.valueOf(this.paddingBottom) + "pt");
        return tcPr;
    }

    public void print() {
        System.out.println("background-color:" + this.backgroundColor + ";");
        System.out.println("border-bottom-color:" + this.borderBottom.getBorderColor() + ";");
        System.out.println("border-bottom-style:" + this.borderBottom.getBorderStyle() + ";");
        System.out.println("border-bottom-width:" + this.borderBottom.getBorderWidth() + "px" + ";");
        System.out.println("border-top-color:" + this.borderTop.getBorderColor() + ";");
        System.out.println("border-top-style:" + this.borderTop.getBorderStyle());
        System.out.println("border-top-width:" + this.borderTop.getBorderWidth() + "px" + ";");
        System.out.println("border-right-color:" + this.borderRight.getBorderColor() + ";");
        System.out.println("border-right-style:" + this.borderRight.getBorderStyle());
        System.out.println("border-right-width:" + this.borderRight.getBorderWidth() + "px" + ";");
        System.out.println("border-left-color:" + this.borderLeft.getBorderColor() + ";");
        System.out.println("border-left-style:" + this.borderLeft.getBorderStyle() + ";");
        System.out.println("border-left-width:" + this.borderLeft.getBorderWidth() + "px" + ";");
        if (this.verticalAlign.equals("center")) {
            System.out.println("vertical-align:middle;");
        } else {
            System.out.println("vertical-align:" + this.verticalAlign + ";");
        }
        System.out.println("padding-left:" + this.paddingLeft + "px" + ";");
        System.out.println("padding-right:" + this.paddingRight + "px" + ";");
        System.out.println("padding-top:" + this.paddingTop + "px" + ";");
        System.out.println("padding-bottom:" + this.paddingBottom + "px" + ";");
    }
}

