/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.InputStream;
import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.io.IOUtils;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.JAXBAssociation;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.XPathBinderAssociationIsPartialException;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.XPathEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxbXmlPartXPathAware<E>
extends JaxbXmlPart<E>
implements XPathEnabled<E> {
    protected static Logger log = LoggerFactory.getLogger(JaxbXmlPartXPathAware.class);
    protected Binder<Node> binder;

    public JaxbXmlPartXPathAware(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Binder<Node> getBinder() {
        if (this.jaxbElement == null) {
            PartStore partStore = this.getPackage().getSourcePartStore();
            InputStream is = null;
            try {
                String name = this.partName.getName();
                try {
                    this.setContentLengthAsLoaded(partStore.getPartSize(name.substring(1)));
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
                is = partStore.loadPart(name.substring(1));
                if (is == null) {
                    log.warn(name + " missing from part store");
                } else {
                    log.info("Lazily unmarshalling " + name);
                    this.unmarshal(is);
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Docx4JException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        } else if (this.binder == null) {
            try {
                log.debug("creating binder for " + this.getJaxbElement().getClass().getName());
                Document doc = XmlUtils.neww3cDomDocument();
                this.marshal(doc);
                this.unmarshal(doc.getDocumentElement());
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.binder;
    }

    @Override
    public void setJaxbElement(E jaxbElement) {
        super.setJaxbElement(jaxbElement);
        this.binder = null;
    }

    @Override
    public E createBinderAndJaxbElement(E source) throws JAXBException {
        log.info("creating binder");
        Document doc = XmlUtils.marshaltoW3CDomDocument(source);
        this.unmarshal(doc.getDocumentElement());
        return (E)this.jaxbElement;
    }

    @Override
    public List<Object> getJAXBNodesViaXPath(String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        Binder<Node> binder = this.getBinder();
        Object el = this.getJaxbElement();
        return XmlUtils.getJAXBNodesViaXPath(binder, el, xpathExpr, refreshXmlFirst);
    }

    @Override
    public List<Object> getJAXBNodesViaXPath(String xpathExpr, Object someJaxbElement, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        return XmlUtils.getJAXBNodesViaXPath(this.getBinder(), someJaxbElement, xpathExpr, refreshXmlFirst);
    }

    @Override
    public List<JAXBAssociation> getJAXBAssociationsForXPath(String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        Object el = this.getJaxbElement();
        return XmlUtils.getJAXBAssociationsForXPath(this.getBinder(), el, xpathExpr, refreshXmlFirst);
    }

    @Override
    public List<JAXBAssociation> getJAXBAssociationsForXPath(Object someJaxbElement, String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        return XmlUtils.getJAXBAssociationsForXPath(this.getBinder(), someJaxbElement, xpathExpr, refreshXmlFirst);
    }

    @Override
    public E unmarshal(InputStream is) throws JAXBException {
        try {
            log.info("For " + this.getClass().getName() + ", unmarshall via binder");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(is);
            this.binder = this.jc.createBinder();
            log.debug("info: " + this.binder.getClass().getName());
            JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
            eventHandler.setContinue(false);
            this.binder.setEventHandler((ValidationEventHandler)eventHandler);
            try {
                this.jaxbElement = XmlUtils.unwrap(this.binder.unmarshal((Object)doc));
            }
            catch (UnmarshalException ue) {
                if (is.markSupported()) {
                    log.info("encountered unexpected content; pre-processing");
                    eventHandler.setContinue(true);
                    DOMResult result = new DOMResult();
                    Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                    XmlUtils.transform(doc, mcPreprocessorXslt, null, (Result)result);
                    doc = (Document)result.getNode();
                    try {
                        this.jaxbElement = XmlUtils.unwrap(this.binder.unmarshal((Object)doc));
                    }
                    catch (ClassCastException cce) {
                        log.warn("Binder not available for this docx");
                        Unmarshaller u = this.jc.createUnmarshaller();
                        this.jaxbElement = XmlUtils.unwrap(u.unmarshal((Node)doc));
                    }
                }
                log.error(ue.getMessage(), (Throwable)ue);
                log.error(".. and mark not supported");
                throw ue;
            }
            return (E)this.jaxbElement;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public E unmarshal(Element el) throws JAXBException {
        try {
            log.info("For " + this.getClass().getName() + ", unmarshall via binder");
            this.binder = this.jc.createBinder();
            JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
            eventHandler.setContinue(false);
            this.binder.setEventHandler((ValidationEventHandler)eventHandler);
            try {
                this.jaxbElement = XmlUtils.unwrap(this.binder.unmarshal((Object)el));
            }
            catch (UnmarshalException ue) {
                log.info("encountered unexpected content; pre-processing");
                Document doc = null;
                try {
                    doc = el instanceof Document ? (Document)((Object)el) : el.getOwnerDocument();
                    eventHandler.setContinue(true);
                    DOMResult result = new DOMResult();
                    Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                    XmlUtils.transform(doc, mcPreprocessorXslt, null, (Result)result);
                    doc = (Document)result.getNode();
                    this.jaxbElement = XmlUtils.unwrap(this.binder.unmarshal((Object)doc));
                }
                catch (ClassCastException cce) {
                    log.warn("Binder not available for this docx");
                    Unmarshaller u = this.jc.createUnmarshaller();
                    this.jaxbElement = XmlUtils.unwrap(u.unmarshal((Node)doc));
                }
                catch (Exception e) {
                    throw new JAXBException("Preprocessing exception", (Throwable)e);
                }
            }
            return (E)this.jaxbElement;
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

